/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.data.peripherals;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.util.Assertions;

public class PeripheralJob
extends TCSObject<PeripheralJob>
implements Serializable {
    @Nonnull
    private final String reservationToken;
    @Nullable
    private final TCSObjectReference<Vehicle> relatedVehicle;
    @Nullable
    private final TCSObjectReference<TransportOrder> relatedTransportOrder;
    @Nonnull
    private final PeripheralOperation peripheralOperation;
    @Nonnull
    private final State state;
    @Nonnull
    private final Instant creationTime;
    @Nonnull
    private final Instant finishedTime;

    public PeripheralJob(@Nonnull String name, @Nonnull String reservationToken, @Nonnull PeripheralOperation peripheralOperation) {
        this(name, new HashMap<String, String>(), new ObjectHistory().withEntryAppended(new ObjectHistory.Entry("tcs:history:jobCreated")), reservationToken, null, null, peripheralOperation, State.TO_BE_PROCESSED, Instant.now(), Instant.MAX);
    }

    private PeripheralJob(String objectName, Map<String, String> properties, ObjectHistory history, String reservationToken, TCSObjectReference<Vehicle> relatedVehicle, TCSObjectReference<TransportOrder> transportOrder, PeripheralOperation peripheralOperation, State state, Instant creationTime, Instant finishedTime) {
        super(objectName, properties, history);
        this.reservationToken = Objects.requireNonNull(reservationToken, "reservationToken");
        Assertions.checkArgument(!reservationToken.isEmpty(), "reservationToken may not be empty.");
        this.relatedVehicle = relatedVehicle;
        this.relatedTransportOrder = transportOrder;
        this.peripheralOperation = Objects.requireNonNull(peripheralOperation, "peripheralOperation");
        this.state = Objects.requireNonNull(state, "state");
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
        this.finishedTime = Objects.requireNonNull(finishedTime, "finishedTime");
    }

    public PeripheralJob withProperty(String key, String value) {
        return new PeripheralJob(this.getName(), this.propertiesWith(key, value), this.getHistory(), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public PeripheralJob withProperties(Map<String, String> properties) {
        return new PeripheralJob(this.getName(), properties, this.getHistory(), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public PeripheralJob withHistoryEntry(ObjectHistory.Entry entry) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory().withEntryAppended(entry), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public PeripheralJob withHistory(ObjectHistory history) {
        return new PeripheralJob(this.getName(), this.getProperties(), history, this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public String getReservationToken() {
        return this.reservationToken;
    }

    public PeripheralJob withReservationToken(String reservationToken) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public TCSObjectReference<Vehicle> getRelatedVehicle() {
        return this.relatedVehicle;
    }

    public PeripheralJob withRelatedVehicle(TCSObjectReference<Vehicle> relatedVehicle) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), this.reservationToken, relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public TCSObjectReference<TransportOrder> getRelatedTransportOrder() {
        return this.relatedTransportOrder;
    }

    public PeripheralJob withRelatedTransportOrder(TCSObjectReference<TransportOrder> relatedTransportOrder) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), this.reservationToken, this.relatedVehicle, relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public PeripheralOperation getPeripheralOperation() {
        return this.peripheralOperation;
    }

    public PeripheralJob withPeripheralOperation(PeripheralOperation peripheralOperation) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, peripheralOperation, this.state, this.creationTime, this.finishedTime);
    }

    public State getState() {
        return this.state;
    }

    public PeripheralJob withState(State state) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, state, this.creationTime, state == State.FINISHED ? Instant.now() : this.finishedTime);
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public PeripheralJob withCreationTime(Instant creationTime) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, creationTime, this.finishedTime);
    }

    public Instant getFinishedTime() {
        return this.finishedTime;
    }

    public PeripheralJob withFinishedTime(Instant finishedTime) {
        return new PeripheralJob(this.getName(), this.getProperties(), this.getHistory(), this.reservationToken, this.relatedVehicle, this.relatedTransportOrder, this.peripheralOperation, this.state, this.creationTime, finishedTime);
    }

    @Override
    public String toString() {
        return "PeripheralJob{name=" + this.getName() + ", reservationToken=" + this.reservationToken + ", relatedVehicle=" + String.valueOf(this.relatedVehicle) + ", relatedTransportOrder=" + String.valueOf(this.relatedTransportOrder) + ", peripheralOperation=" + String.valueOf(this.peripheralOperation) + ", state=" + String.valueOf((Object)this.state) + ", creationTime=" + String.valueOf(this.creationTime) + ", finishedTime=" + String.valueOf(this.finishedTime) + "}";
    }

    public static enum State {
        TO_BE_PROCESSED,
        BEING_PROCESSED,
        FINISHED,
        FAILED;


        public boolean isFinalState() {
            return this.equals((Object)FINISHED) || this.equals((Object)FAILED);
        }
    }
}

