/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.customizations.kernel;

import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import org.opentcs.components.kernel.Dispatcher;
import org.opentcs.components.kernel.KernelExtension;
import org.opentcs.components.kernel.OrderSequenceCleanupApproval;
import org.opentcs.components.kernel.PeripheralJobCleanupApproval;
import org.opentcs.components.kernel.PeripheralJobDispatcher;
import org.opentcs.components.kernel.Router;
import org.opentcs.components.kernel.Scheduler;
import org.opentcs.components.kernel.TransportOrderCleanupApproval;
import org.opentcs.components.kernel.routing.EdgeEvaluator;
import org.opentcs.customizations.ConfigurableInjectionModule;
import org.opentcs.customizations.kernel.ActiveInAllModes;
import org.opentcs.customizations.kernel.ActiveInModellingMode;
import org.opentcs.customizations.kernel.ActiveInOperatingMode;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterFactory;
import org.opentcs.drivers.vehicle.VehicleCommAdapterFactory;

public abstract class KernelInjectionModule
extends ConfigurableInjectionModule {
    protected void bindScheduler(Class<? extends Scheduler> clazz) {
        this.bind(Scheduler.class).to(clazz).in(Singleton.class);
    }

    protected void bindRouter(Class<? extends Router> clazz) {
        this.bind(Router.class).to(clazz).in(Singleton.class);
    }

    protected void bindDispatcher(Class<? extends Dispatcher> clazz) {
        this.bind(Dispatcher.class).to(clazz).in(Singleton.class);
    }

    protected void bindPeripheralJobDispatcher(Class<? extends PeripheralJobDispatcher> clazz) {
        this.bind(PeripheralJobDispatcher.class).to(clazz).in(Singleton.class);
    }

    protected Multibinder<KernelExtension> extensionsBinderAllModes() {
        return Multibinder.newSetBinder((Binder)this.binder(), KernelExtension.class, ActiveInAllModes.class);
    }

    protected Multibinder<KernelExtension> extensionsBinderModelling() {
        return Multibinder.newSetBinder((Binder)this.binder(), KernelExtension.class, ActiveInModellingMode.class);
    }

    protected Multibinder<KernelExtension> extensionsBinderOperating() {
        return Multibinder.newSetBinder((Binder)this.binder(), KernelExtension.class, ActiveInOperatingMode.class);
    }

    protected Multibinder<VehicleCommAdapterFactory> vehicleCommAdaptersBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), VehicleCommAdapterFactory.class);
    }

    protected Multibinder<PeripheralCommAdapterFactory> peripheralCommAdaptersBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), PeripheralCommAdapterFactory.class);
    }

    protected Multibinder<TransportOrderCleanupApproval> transportOrderCleanupApprovalBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), TransportOrderCleanupApproval.class);
    }

    protected Multibinder<OrderSequenceCleanupApproval> orderSequenceCleanupApprovalBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), OrderSequenceCleanupApproval.class);
    }

    protected Multibinder<PeripheralJobCleanupApproval> peripheralJobCleanupApprovalBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), PeripheralJobCleanupApproval.class);
    }

    protected Multibinder<Scheduler.Module> schedulerModuleBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), Scheduler.Module.class);
    }

    protected MapBinder<String, EdgeEvaluator> edgeEvaluatorBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)TypeLiteral.get(EdgeEvaluator.class));
    }
}

