/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.common;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingScheduledThreadPoolExecutor.class);

    public LoggingScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                } else {
                    if (this.isPeriodic(future)) {
                        return;
                    }
                    LOG.debug("Future was not done: {}", (Object)future);
                }
            }
            catch (ExecutionException ee) {
                LOG.warn("Unhandled exception in executed task", ee.getCause());
            }
            catch (CancellationException ce) {
                LOG.debug("Task was cancelled", (Throwable)ce);
            }
            catch (InterruptedException ie) {
                LOG.debug("Interrupted during Future.get()", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            LOG.error("Abrupt termination", t);
        }
    }

    private boolean isPeriodic(Future<?> future) {
        RunnableScheduledFuture runnableFuture;
        return future instanceof RunnableScheduledFuture && (runnableFuture = (RunnableScheduledFuture)future).isPeriodic();
    }
}

