/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import java.util.Comparator;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.visualization.ModelLayoutElement;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;

public final class Comparators {
    private Comparators() {
    }

    public static Comparator<TCSObject<?>> objectsByName() {
        return Comparator.comparing(TCSObject::getName);
    }

    public static Comparator<TCSObjectReference<?>> referencesByName() {
        return Comparator.comparing(TCSObjectReference::getName);
    }

    public static Comparator<TransportOrder> ordersByDeadline() {
        return Comparator.comparing(TransportOrder::getDeadline).thenComparing(Comparators.ordersByAge());
    }

    public static Comparator<TransportOrder> ordersByAge() {
        return Comparator.comparing(TransportOrder::getCreationTime).thenComparing(Comparators.objectsByName());
    }

    public static Comparator<PeripheralJob> jobsByAge() {
        return Comparator.comparing(PeripheralJob::getCreationTime).thenComparing(Comparators.objectsByName());
    }

    @Deprecated
    public static Comparator<ModelLayoutElement> modelLayoutElementsByName() {
        return (o1, o2) -> o1.getVisualizedObject().getName().compareTo(o2.getVisualizedObject().getName());
    }
}

