/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import java.util.Objects;
import org.opentcs.util.Assertions;

public final class NumberParsers {
    private static final int MAX_POSITIVE_LONG_CHARS = Long.toString(Long.MAX_VALUE).length();
    private static final int MAX_NEGATIVE_LONG_CHARS = Long.toString(Long.MIN_VALUE).length();

    private NumberParsers() {
    }

    public static long parsePureDecimalLong(CharSequence source) throws NumberFormatException {
        return NumberParsers.parsePureDecimalLong(source, 0, source.length());
    }

    public static long parsePureDecimalLong(CharSequence source, int startIndex, int length) throws NumberFormatException {
        long limit;
        boolean negative;
        Objects.requireNonNull(source, "source");
        Assertions.checkInRange((int)startIndex, (int)0, (int)(source.length() - 1), (String)"startIndex");
        Assertions.checkInRange((int)length, (int)1, (int)Integer.MAX_VALUE, (String)"length");
        long result = 0L;
        int index = 0;
        if (source.charAt(startIndex) == '-') {
            if (length > MAX_NEGATIVE_LONG_CHARS) {
                throw new NumberFormatException("too long to be parsed");
            }
            negative = true;
            limit = Long.MIN_VALUE;
            ++index;
        } else {
            if (length > MAX_POSITIVE_LONG_CHARS) {
                throw new NumberFormatException("too long to be parsed");
            }
            negative = false;
            limit = -9223372036854775807L;
        }
        while (index < length) {
            int digit = source.charAt(startIndex + index) - 48;
            if (digit < 0 || digit > 9) {
                throw new NumberFormatException("not a decimal digit: " + source.charAt(startIndex + index));
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException("parsed number exceeds value boundaries");
            }
            result -= (long)digit;
            ++index;
        }
        if (negative) {
            if (index < 2) {
                throw new NumberFormatException("minus sign without succeeding digits");
            }
            return result;
        }
        return -result;
    }
}

