/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opentcs.util.gui.Icons;
import org.opentcs.util.gui.dialog.CancelButton;
import org.opentcs.util.gui.dialog.ConnectionParamSet;

public class ConnectToServerDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/common/Bundle");
    private String description;
    private String host;
    private int port;
    private final List<ConnectionParamSet> paramSets;
    private int returnStatus = 0;
    private JButton cancelButton;
    private JComboBox<ConnectionParamSet> cbComboBox;
    private JLabel labelDescription;
    private JLabel labelPort;
    private JLabel labelServer;
    private JButton okButton;
    private JPanel panelButtons;
    private JTextField textFieldDescription;
    private JTextField textFieldPort;
    private JTextField textFieldServer;

    public ConnectToServerDialog(List<ConnectionParamSet> paramSets) {
        super((Frame)null, true);
        this.paramSets = Objects.requireNonNull(paramSets, "paramSets");
        this.initComponents();
        this.initConnectionBookmarks();
        if (paramSets.isEmpty()) {
            this.description = "Localhost";
            this.host = "localhost";
            this.port = 1099;
        } else {
            this.description = paramSets.get(0).getDescription();
            this.host = paramSets.get(0).getHost();
            this.port = paramSets.get(0).getPort();
        }
        this.textFieldDescription.setText(this.description);
        this.textFieldServer.setText(this.host);
        this.textFieldPort.setText(String.valueOf(this.port));
        this.getRootPane().setDefaultButton(this.okButton);
        this.setIconImages(Icons.getOpenTCSIcons());
        this.setLocationRelativeTo(null);
        this.pack();
    }

    public String getDescription() {
        return this.description;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void initConnectionBookmarks() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbComboBox.getModel();
        for (ConnectionParamSet bookmark : this.paramSets) {
            model.addElement(bookmark);
        }
    }

    private void initComponents() {
        this.labelDescription = new JLabel();
        this.textFieldDescription = new JTextField();
        this.labelServer = new JLabel();
        this.textFieldServer = new JTextField();
        this.labelPort = new JLabel();
        this.textFieldPort = new JTextField();
        this.panelButtons = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new CancelButton();
        this.cbComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/common/Bundle");
        this.setTitle(bundle.getString("connectToServerDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.labelDescription.setFont(this.labelDescription.getFont());
        this.labelDescription.setText(bundle.getString("connectToServerDialog.label_description.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.getContentPane().add((Component)this.labelDescription, gridBagConstraints);
        this.textFieldDescription.setColumns(15);
        this.textFieldDescription.setFont(this.textFieldDescription.getFont());
        this.textFieldDescription.setText("Localhost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 8);
        this.getContentPane().add((Component)this.textFieldDescription, gridBagConstraints);
        this.labelServer.setFont(this.labelServer.getFont());
        this.labelServer.setText(bundle.getString("connectToServerDialog.label_host.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.getContentPane().add((Component)this.labelServer, gridBagConstraints);
        this.textFieldServer.setColumns(15);
        this.textFieldServer.setFont(this.textFieldServer.getFont());
        this.textFieldServer.setText("localhost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 8);
        this.getContentPane().add((Component)this.textFieldServer, gridBagConstraints);
        this.labelPort.setFont(this.labelPort.getFont());
        this.labelPort.setText(bundle.getString("connectToServerDialog.label_port.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.getContentPane().add((Component)this.labelPort, gridBagConstraints);
        this.textFieldPort.setColumns(15);
        this.textFieldPort.setFont(this.textFieldPort.getFont());
        this.textFieldPort.setText("1099");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 8);
        this.getContentPane().add((Component)this.textFieldPort, gridBagConstraints);
        this.panelButtons.setLayout(new GridBagLayout());
        this.okButton.setFont(this.okButton.getFont().deriveFont(this.okButton.getFont().getStyle() | 1));
        this.okButton.setText(bundle.getString("connectToServerDialog.button_ok.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectToServerDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelButtons.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setFont(this.cancelButton.getFont());
        this.cancelButton.setText(bundle.getString("connectToServerDialog.button_cancle.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectToServerDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.panelButtons.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.panelButtons, gridBagConstraints);
        this.cbComboBox.setFont(new Font("Arial", 0, 11));
        this.cbComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectToServerDialog.this.cbComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 8);
        this.getContentPane().add(this.cbComboBox, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.description = this.textFieldDescription.getText();
        if (this.description.isEmpty()) {
            JOptionPane.showMessageDialog(this, BUNDLE.getString("connectToServerDialog.optionPane_invalidDescription.message"), BUNDLE.getString("connectToServerDialog.optionPane_invalidDescription.title"), 0);
            return;
        }
        this.host = this.textFieldServer.getText();
        if (this.host.isEmpty()) {
            JOptionPane.showMessageDialog(this, BUNDLE.getString("connectToServerDialog.optionPane_invalidHost.message"), BUNDLE.getString("connectToServerDialog.optionPane_invalidHost.title"), 0);
            return;
        }
        try {
            this.port = Integer.parseInt(this.textFieldPort.getText());
            if (this.port < 0 || this.port > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, BUNDLE.getString("connectToServerDialog.optionPane_invalidPort.message"), BUNDLE.getString("connectToServerDialog.optionPane_invalidPort.title"), 0);
            return;
        }
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void cbComboBoxActionPerformed(ActionEvent evt) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbComboBox.getModel();
        ConnectionParamSet cb = (ConnectionParamSet)model.getSelectedItem();
        if (cb != null) {
            this.textFieldDescription.setText(cb.getDescription());
            this.textFieldServer.setText(cb.getHost());
            this.textFieldPort.setText(String.valueOf(cb.getPort()));
        }
    }
}

