/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.persistence.v004;

import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.data.model.visualization.LocationRepresentation;
import org.opentcs.util.Colors;
import org.opentcs.util.persistence.v003.V003ModelParser;
import org.opentcs.util.persistence.v003.V003PlantModelTO;
import org.opentcs.util.persistence.v003.VisualLayoutTO;
import org.opentcs.util.persistence.v004.AllowedOperationTO;
import org.opentcs.util.persistence.v004.BlockTO;
import org.opentcs.util.persistence.v004.LocationTO;
import org.opentcs.util.persistence.v004.LocationTypeTO;
import org.opentcs.util.persistence.v004.MemberTO;
import org.opentcs.util.persistence.v004.PathTO;
import org.opentcs.util.persistence.v004.PointTO;
import org.opentcs.util.persistence.v004.PropertyTO;
import org.opentcs.util.persistence.v004.V004PlantModelTO;
import org.opentcs.util.persistence.v004.V004TOMapper;
import org.opentcs.util.persistence.v004.VehicleTO;
import org.opentcs.util.persistence.v004.VisualLayoutTO;

public class V004ModelParser {
    public PlantModelCreationTO read(Reader reader, String modelVersion) throws IOException {
        return new V004TOMapper().map(this.readRaw(reader, modelVersion));
    }

    public V004PlantModelTO readRaw(Reader reader, String modelVersion) throws IOException {
        if (Objects.equals(modelVersion, "0.0.4")) {
            return V004PlantModelTO.fromXml(reader);
        }
        return this.convert(new V003ModelParser().readRaw(reader, modelVersion));
    }

    private V004PlantModelTO convert(V003PlantModelTO to) {
        Map<String, VisualLayoutTO.ModelLayoutElement> modelLayoutElementMap = this.getModelLayoutElementMap(to);
        V004PlantModelTO result = new V004PlantModelTO().setName(to.getName()).setPoints(this.convertPoints(to, modelLayoutElementMap)).setPaths(this.convertPaths(to, modelLayoutElementMap)).setVehicles(this.convertVehicles(to, modelLayoutElementMap)).setLocationTypes(this.convertLocationTypes(to)).setLocations(this.convertLocations(to, modelLayoutElementMap)).setBlocks(this.convertBlocks(to, modelLayoutElementMap)).setVisualLayout(this.convertVisualLayout(to)).setProperties(this.convertProperties(to.getProperties()));
        return this.assignElementsToDefaultLayer(result);
    }

    private Map<String, VisualLayoutTO.ModelLayoutElement> getModelLayoutElementMap(V003PlantModelTO to) {
        HashMap<String, VisualLayoutTO.ModelLayoutElement> result = new HashMap<String, VisualLayoutTO.ModelLayoutElement>();
        for (VisualLayoutTO.ModelLayoutElement mle : to.getVisualLayouts().get(0).getModelLayoutElements()) {
            result.put(mle.getVisualizedObjectName(), mle);
        }
        return result;
    }

    private List<PropertyTO> convertProperties(List<org.opentcs.util.persistence.v003.PropertyTO> tos) {
        return tos.stream().map(property -> new PropertyTO().setName(property.getName()).setValue(property.getValue())).collect(Collectors.toList());
    }

    private V004PlantModelTO assignElementsToDefaultLayer(V004PlantModelTO model) {
        ArrayList<PointTO> pointsAssignedToDefaultLayer = new ArrayList<PointTO>();
        for (PointTO pointTO : model.getPoints()) {
            pointsAssignedToDefaultLayer.add(pointTO.setPointLayout(pointTO.getPointLayout().setLayerId(0)));
        }
        ArrayList<PathTO> pathsAssignedToDefaultLayer = new ArrayList<PathTO>();
        for (PathTO path : model.getPaths()) {
            pathsAssignedToDefaultLayer.add(path.setPathLayout(path.getPathLayout().setLayerId(0)));
        }
        ArrayList<LocationTO> arrayList = new ArrayList<LocationTO>();
        for (LocationTO path : model.getLocations()) {
            arrayList.add(path.setLocationLayout(path.getLocationLayout().setLayerId(0)));
        }
        return model.setPoints(pointsAssignedToDefaultLayer).setPaths(pathsAssignedToDefaultLayer).setLocations(arrayList);
    }

    private List<PointTO> convertPoints(V003PlantModelTO to, Map<String, VisualLayoutTO.ModelLayoutElement> modelLayoutElementMap) {
        return to.getPoints().stream().map(point -> {
            Map<String, String> layoutProperties = this.toPropertiesMap(((VisualLayoutTO.ModelLayoutElement)modelLayoutElementMap.get(point.getName())).getProperties());
            long positionX = layoutProperties.get("POSITION_X") != null ? (long)Integer.parseInt(layoutProperties.get("POSITION_X")) : 0L;
            long positionY = layoutProperties.get("POSITION_Y") != null ? (long)Integer.parseInt(layoutProperties.get("POSITION_Y")) : 0L;
            long labelOffsetX = layoutProperties.get("LABEL_OFFSET_X") != null ? (long)Integer.parseInt(layoutProperties.get("LABEL_OFFSET_X")) : 0L;
            long labelOffsetY = layoutProperties.get("LABEL_OFFSET_Y") != null ? (long)Integer.parseInt(layoutProperties.get("LABEL_OFFSET_Y")) : 0L;
            PointTO result = new PointTO();
            result.setName(point.getName()).setProperties(this.convertProperties(point.getProperties()));
            result.setxPosition(point.getxPosition()).setyPosition(point.getyPosition()).setzPosition(point.getzPosition()).setVehicleOrientationAngle(point.getVehicleOrientationAngle()).setType(point.getType()).setOutgoingPaths(this.convertOutgoingPaths((org.opentcs.util.persistence.v003.PointTO)point)).setPointLayout(new PointTO.PointLayout().setxPosition(positionX).setyPosition(positionY).setxLabelOffset(labelOffsetX).setyLabelOffset(labelOffsetY));
            return result;
        }).collect(Collectors.toList());
    }

    private Map<String, String> toPropertiesMap(List<org.opentcs.util.persistence.v003.PropertyTO> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (org.opentcs.util.persistence.v003.PropertyTO property : properties) {
            result.put(property.getName(), property.getValue());
        }
        return result;
    }

    private List<PointTO.OutgoingPath> convertOutgoingPaths(org.opentcs.util.persistence.v003.PointTO to) {
        return to.getOutgoingPaths().stream().map(path -> new PointTO.OutgoingPath().setName(path.getName())).collect(Collectors.toList());
    }

    private List<PathTO> convertPaths(V003PlantModelTO to, Map<String, VisualLayoutTO.ModelLayoutElement> modelLayoutElementMap) {
        return to.getPaths().stream().map(path -> {
            Map<String, String> layoutProperties = this.toPropertiesMap(((VisualLayoutTO.ModelLayoutElement)modelLayoutElementMap.get(path.getName())).getProperties());
            String connectionType = layoutProperties.getOrDefault("CONN_TYPE", "DIRECT");
            ArrayList<PathTO.ControlPoint> controlPoints = new ArrayList();
            String controlPointsString = layoutProperties.get("CONTROL_POINTS");
            if (controlPointsString != null) {
                controlPoints = Arrays.asList(controlPointsString.split(";")).stream().map(controlPointString -> {
                    String[] coordinateStrings = controlPointString.split(",");
                    return new PathTO.ControlPoint().setX(Long.parseLong(coordinateStrings[0])).setY(Long.parseLong(coordinateStrings[1]));
                }).collect(Collectors.toList());
            }
            PathTO result = new PathTO();
            result.setName(path.getName()).setProperties(this.convertProperties(path.getProperties()));
            result.setSourcePoint(path.getSourcePoint()).setDestinationPoint(path.getDestinationPoint()).setLength(path.getLength()).setMaxVelocity(path.getMaxVelocity()).setMaxReverseVelocity(path.getMaxReverseVelocity()).setLocked(path.isLocked()).setPathLayout(new PathTO.PathLayout().setConnectionType(connectionType).setControlPoints(controlPoints));
            return result;
        }).collect(Collectors.toList());
    }

    private List<VehicleTO> convertVehicles(V003PlantModelTO to, Map<String, VisualLayoutTO.ModelLayoutElement> modelLayoutElementMap) {
        return to.getVehicles().stream().map(vehicle -> {
            Map<String, String> layoutProperties = this.toPropertiesMap(((VisualLayoutTO.ModelLayoutElement)modelLayoutElementMap.get(vehicle.getName())).getProperties());
            String color = layoutProperties.get("ROUTE_COLOR") != null ? layoutProperties.get("ROUTE_COLOR") : Colors.encodeToHexRGB(Color.RED);
            VehicleTO result = new VehicleTO();
            result.setName(vehicle.getName()).setProperties(this.convertProperties(vehicle.getProperties()));
            result.setLength(vehicle.getLength()).setEnergyLevelCritical(vehicle.getEnergyLevelCritical()).setEnergyLevelGood(vehicle.getEnergyLevelGood()).setEnergyLevelFullyRecharged(vehicle.getEnergyLevelFullyRecharged()).setEnergyLevelSufficientlyRecharged(vehicle.getEnergyLevelSufficientlyRecharged()).setMaxVelocity(vehicle.getMaxVelocity()).setMaxReverseVelocity(vehicle.getMaxReverseVelocity()).setVehicleLayout(new VehicleTO.VehicleLayout().setColor(color));
            return result;
        }).collect(Collectors.toList());
    }

    private List<LocationTypeTO> convertLocationTypes(V003PlantModelTO to) {
        return to.getLocationTypes().stream().map(locationType -> {
            String locationRepresentation = this.toPropertiesMap(locationType.getProperties()).getOrDefault("tcs:defaultLocationTypeSymbol", LocationRepresentation.NONE.name());
            LocationTypeTO result = new LocationTypeTO();
            result.setName(locationType.getName()).setProperties(this.convertProperties(locationType.getProperties()));
            result.setAllowedOperations(this.convertAllowedOperations(locationType.getAllowedOperations())).setLocationTypeLayout(new LocationTypeTO.LocationTypeLayout().setLocationRepresentation(locationRepresentation));
            return result;
        }).collect(Collectors.toList());
    }

    private List<AllowedOperationTO> convertAllowedOperations(List<org.opentcs.util.persistence.v003.AllowedOperationTO> tos) {
        return tos.stream().map(allowedOperation -> {
            AllowedOperationTO result = new AllowedOperationTO();
            result.setName(allowedOperation.getName());
            result.setProperties(this.convertProperties(allowedOperation.getProperties()));
            return result;
        }).collect(Collectors.toList());
    }

    private List<LocationTO> convertLocations(V003PlantModelTO to, Map<String, VisualLayoutTO.ModelLayoutElement> modelLayoutElementMap) {
        return to.getLocations().stream().map(location -> {
            Map<String, String> layoutProperties = this.toPropertiesMap(((VisualLayoutTO.ModelLayoutElement)modelLayoutElementMap.get(location.getName())).getProperties());
            long positionX = layoutProperties.get("POSITION_X") != null ? (long)Integer.parseInt(layoutProperties.get("POSITION_X")) : 0L;
            long positionY = layoutProperties.get("POSITION_Y") != null ? (long)Integer.parseInt(layoutProperties.get("POSITION_Y")) : 0L;
            long labelOffsetX = layoutProperties.get("LABEL_OFFSET_X") != null ? (long)Integer.parseInt(layoutProperties.get("LABEL_OFFSET_X")) : 0L;
            long labelOffsetY = layoutProperties.get("LABEL_OFFSET_Y") != null ? (long)Integer.parseInt(layoutProperties.get("LABEL_OFFSET_Y")) : 0L;
            String locationRepresentation = this.toPropertiesMap(location.getProperties()).getOrDefault("tcs:defaultLocationSymbol", LocationRepresentation.DEFAULT.name());
            LocationTO result = new LocationTO();
            result.setName(location.getName()).setProperties(this.convertProperties(location.getProperties()));
            result.setxPosition(location.getxPosition()).setyPosition(location.getyPosition()).setzPosition(location.getzPosition()).setType(location.getType()).setLinks(this.convertLinks((org.opentcs.util.persistence.v003.LocationTO)location)).setLocked(location.isLocked()).setLocationLayout(new LocationTO.LocationLayout().setxPosition(positionX).setyPosition(positionY).setxLabelOffset(labelOffsetX).setyLabelOffset(labelOffsetY).setLocationRepresentation(locationRepresentation));
            return result;
        }).collect(Collectors.toList());
    }

    private List<LocationTO.Link> convertLinks(org.opentcs.util.persistence.v003.LocationTO to) {
        return to.getLinks().stream().map(link -> new LocationTO.Link().setPoint(link.getPoint()).setAllowedOperations(this.convertAllowedOperations(link.getAllowedOperations()))).collect(Collectors.toList());
    }

    private List<BlockTO> convertBlocks(V003PlantModelTO to, Map<String, VisualLayoutTO.ModelLayoutElement> modelLayoutElementMap) {
        return to.getBlocks().stream().map(block -> {
            Map<String, String> layoutProperties = this.toPropertiesMap(((VisualLayoutTO.ModelLayoutElement)modelLayoutElementMap.get(block.getName())).getProperties());
            String color = layoutProperties.get("COLOR") != null ? layoutProperties.get("COLOR") : Colors.encodeToHexRGB(Color.RED);
            BlockTO result = new BlockTO();
            result.setName(block.getName()).setProperties(this.convertProperties(block.getProperties()));
            result.setType(block.getType()).setMembers(this.convertMembers(block.getMembers())).setBlockLayout(new BlockTO.BlockLayout().setColor(color));
            return result;
        }).collect(Collectors.toList());
    }

    private List<MemberTO> convertMembers(List<org.opentcs.util.persistence.v003.MemberTO> tos) {
        return tos.stream().map(member -> {
            MemberTO result = new MemberTO();
            result.setName(member.getName()).setProperties(this.convertProperties(member.getProperties()));
            return result;
        }).collect(Collectors.toList());
    }

    private VisualLayoutTO convertVisualLayout(V003PlantModelTO to) {
        VisualLayoutTO result = new VisualLayoutTO();
        result.setName(to.getVisualLayouts().get(0).getName()).setProperties(this.convertProperties(to.getVisualLayouts().get(0).getProperties()));
        result.setScaleX(to.getVisualLayouts().get(0).getScaleX()).setScaleY(to.getVisualLayouts().get(0).getScaleY()).setLayers(this.createDefaultLayer()).setLayerGroups(this.createDefaultLayerGroup());
        return result;
    }

    private List<VisualLayoutTO.Layer> createDefaultLayer() {
        return Arrays.asList(new VisualLayoutTO.Layer().setId(0).setOrdinal(0).setVisible(Boolean.TRUE).setName("Default layer").setGroupId(0));
    }

    private List<VisualLayoutTO.LayerGroup> createDefaultLayerGroup() {
        return Arrays.asList(new VisualLayoutTO.LayerGroup().setId(0).setVisible(Boolean.TRUE).setName("Default layer group"));
    }
}

