/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opentcs.util.Assertions;
import org.opentcs.util.NumberParsers;

public class UniqueStringGenerator<S> {
    private final Map<S, NamePattern> namePatterns = new HashMap<S, NamePattern>();
    private final SortedSet<String> existingStrings = new TreeSet<String>();

    public void registerNamePattern(S selector, String prefix, String suffixPattern) {
        this.namePatterns.put(selector, new NamePattern(prefix, suffixPattern));
    }

    public void addString(String newString) {
        Objects.requireNonNull(newString, "newString is null");
        this.existingStrings.add(newString);
    }

    public void removeString(String rmString) {
        Objects.requireNonNull(rmString, "rmString is null");
        this.existingStrings.remove(rmString);
    }

    public boolean hasString(String str) {
        return this.existingStrings.contains(str);
    }

    public void clear() {
        this.existingStrings.clear();
    }

    public String getUniqueString(S selector) {
        Objects.requireNonNull(selector, "selector");
        NamePattern namePattern = this.namePatterns.get(selector);
        Assertions.checkArgument((namePattern != null ? 1 : 0) != 0, (String)"Unknown selector: %s", (Object[])new Object[]{selector});
        return this.getUniqueString(namePattern.prefix, namePattern.suffixPattern);
    }

    public String getUniqueString(String prefix, String suffixPattern) {
        Objects.requireNonNull(suffixPattern, "suffixPattern is null");
        String actualPrefix = prefix == null ? "" : prefix;
        DecimalFormat format = new DecimalFormat(suffixPattern);
        String lBound = actualPrefix + "0";
        String uBound = actualPrefix + ":";
        int prefixLength = actualPrefix.length();
        long maxSuffixValue = 0L;
        for (String curName : this.existingStrings.subSet(lBound, uBound)) {
            boolean allDigits = this.containsOnlyDigits(curName.substring(prefixLength));
            if (!allDigits) continue;
            long curSuffixValue = NumberParsers.parsePureDecimalLong(curName, prefixLength, curName.length() - prefixLength);
            maxSuffixValue = maxSuffixValue > curSuffixValue ? maxSuffixValue : curSuffixValue;
        }
        return actualPrefix + format.format(maxSuffixValue + 1L);
    }

    private boolean containsOnlyDigits(String input) {
        assert (input != null);
        for (int i = 0; i < input.length(); ++i) {
            int digit = input.charAt(i) - 48;
            if (digit >= 0 && digit <= 9) continue;
            return false;
        }
        return true;
    }

    private static class NamePattern {
        private final String prefix;
        private final String suffixPattern;

        private NamePattern(String prefix, String suffixPattern) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.suffixPattern = Objects.requireNonNull(suffixPattern, "suffixPattern");
        }
    }
}

