/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import java.util.Comparator;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.visualization.ModelLayoutElement;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;

public final class Comparators {
    private static final Comparator<TCSObject<?>> OBJECTS_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private static final Comparator<TCSObjectReference<?>> REFERENCES_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private static final Comparator<TransportOrder> ORDERS_BY_AGE = (o1, o2) -> {
        if (o1.getCreationTime().isBefore(o2.getCreationTime())) {
            return -1;
        }
        if (o1.getCreationTime().isAfter(o2.getCreationTime())) {
            return 1;
        }
        return OBJECTS_BY_NAME.compare((TCSObject<?>)o1, (TCSObject<?>)o2);
    };
    private static final Comparator<TransportOrder> ORDERS_BY_DEADLINE = (o1, o2) -> {
        if (o1.getDeadline().isBefore(o2.getDeadline())) {
            return -1;
        }
        if (o1.getDeadline().isAfter(o2.getDeadline())) {
            return 1;
        }
        return ORDERS_BY_AGE.compare((TransportOrder)o1, (TransportOrder)o2);
    };
    private static final Comparator<PeripheralJob> JOBS_BY_AGE = (o1, o2) -> {
        if (o1.getCreationTime().isBefore(o2.getCreationTime())) {
            return -1;
        }
        if (o1.getCreationTime().isAfter(o2.getCreationTime())) {
            return 1;
        }
        return OBJECTS_BY_NAME.compare((TCSObject<?>)o1, (TCSObject<?>)o2);
    };
    @Deprecated
    private static final Comparator<ModelLayoutElement> LAYOUT_ELEMS_BY_NAME = (o1, o2) -> o1.getVisualizedObject().getName().compareTo(o2.getVisualizedObject().getName());

    private Comparators() {
    }

    public static Comparator<TCSObject<?>> objectsByName() {
        return OBJECTS_BY_NAME;
    }

    public static Comparator<TCSObjectReference<?>> referencesByName() {
        return REFERENCES_BY_NAME;
    }

    public static Comparator<TransportOrder> ordersByDeadline() {
        return ORDERS_BY_DEADLINE;
    }

    public static Comparator<TransportOrder> ordersByAge() {
        return ORDERS_BY_AGE;
    }

    public static Comparator<PeripheralJob> jobsByAge() {
        return JOBS_BY_AGE;
    }

    @Deprecated
    public static Comparator<ModelLayoutElement> modelLayoutElementsByName() {
        return LAYOUT_ELEMS_BY_NAME;
    }
}

