/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.opentcs.util.Assertions;

public final class Streams {
    private static final int INITIAL_BUFFER_SIZE = 10000;

    private Streams() {
    }

    public static InputStream getInputStreamToEndTag(InputStream inStream, byte[] endTag, boolean includeEndTag) throws IOException {
        Objects.requireNonNull(inStream, "inStream");
        Objects.requireNonNull(endTag, "endTag");
        Assertions.checkInRange((int)endTag.length, (int)1, (int)Integer.MAX_VALUE, (String)"endTag.length");
        SearchableByteArrayOutputStream localBuffer = new SearchableByteArrayOutputStream();
        boolean endTagFound = false;
        int currentByte = inStream.read();
        while (!endTagFound && currentByte != -1) {
            localBuffer.write(currentByte);
            endTagFound = localBuffer.endsWith(endTag);
            currentByte = inStream.read();
        }
        if (endTagFound) {
            byte[] input = localBuffer.toByteArray();
            ByteArrayInputStream result = includeEndTag ? new ByteArrayInputStream(input) : new ByteArrayInputStream(input, 0, input.length - endTag.length);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCompleteInputStream(InputStream inStream) throws IOException {
        Objects.requireNonNull(inStream, "inStream");
        int bufferSize = 10000;
        int offset = 0;
        byte[] buffer = new byte[bufferSize];
        try {
            int bytesRead = inStream.read(buffer, offset, bufferSize - offset);
            while (bytesRead != -1) {
                if ((offset += bytesRead) == bufferSize) {
                    buffer = Arrays.copyOf(buffer, bufferSize *= 2);
                }
                bytesRead = inStream.read(buffer, offset, bufferSize - offset);
            }
        }
        finally {
            inStream.close();
        }
        if (offset < bufferSize) {
            buffer = Arrays.copyOf(buffer, offset);
        }
        return buffer;
    }

    private static class SearchableByteArrayOutputStream
    extends ByteArrayOutputStream {
        public boolean endsWith(byte[] endTag) {
            boolean result = false;
            if (this.count >= endTag.length) {
                result = true;
                for (int i = 1; i <= endTag.length; ++i) {
                    if (endTag[endTag.length - i] == this.buf[this.count - i]) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
    }
}

