/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class BoundsPopupMenuListener
implements PopupMenuListener {
    private JScrollPane scrollPane;

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        if (comboBox.getItemCount() == 0) {
            return;
        }
        Accessible child = comboBox.getAccessibleContext().getAccessibleChild(0);
        if (child instanceof BasicComboPopup) {
            SwingUtilities.invokeLater(() -> this.customizePopup((BasicComboPopup)child));
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.scrollPane != null) {
            this.scrollPane.setHorizontalScrollBar(null);
        }
    }

    protected void customizePopup(BasicComboPopup popup) {
        this.scrollPane = this.getScrollPane(popup);
        this.popupWider(popup);
        Component comboBox = popup.getInvoker();
        Point location = comboBox.getLocationOnScreen();
        int height = comboBox.getSize().height;
        popup.setLocation(location.x, location.y + height - 1);
        popup.setLocation(location.x, location.y + height);
    }

    protected void popupWider(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        int popupWidth = list.getPreferredSize().width + 5 + this.getScrollBarWidth(popup, this.scrollPane);
        Dimension scrollPaneSize = this.scrollPane.getPreferredSize();
        scrollPaneSize.width = popupWidth = Math.max(popupWidth, scrollPaneSize.width);
        this.scrollPane.setPreferredSize(scrollPaneSize);
        this.scrollPane.setMaximumSize(scrollPaneSize);
    }

    protected JScrollPane getScrollPane(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        return (JScrollPane)c;
    }

    protected int getScrollBarWidth(BasicComboPopup popup, JScrollPane scrollPane) {
        JComboBox comboBox = (JComboBox)popup.getInvoker();
        if (comboBox.getItemCount() > comboBox.getMaximumRowCount()) {
            return scrollPane.getVerticalScrollBar().getPreferredSize().width;
        }
        return 0;
    }
}

