/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.gui.dialog;

import java.util.Objects;
import org.opentcs.util.Assertions;

public class ConnectionParamSet {
    private final String description;
    private final String host;
    private final int port;

    public ConnectionParamSet(String description, String host, int port) {
        this.description = Objects.requireNonNull(description, "description");
        this.host = Objects.requireNonNull(host);
        this.port = Assertions.checkInRange((int)port, (int)0, (int)65535, (String)"port");
    }

    public ConnectionParamSet(String description, String host, String port) throws NumberFormatException, IllegalArgumentException {
        this(description, host, Integer.parseInt(port));
    }

    public ConnectionParamSet(String paramString) {
        Objects.requireNonNull(paramString, "paramString");
        String[] split = paramString.split("\\|", 3);
        Assertions.checkArgument((split.length == 3 ? 1 : 0) != 0, (String)"Could not parse input as 'description:host:port': %s", (Object[])new Object[]{paramString});
        this.description = split[0];
        this.host = split[1];
        this.port = Assertions.checkInRange((int)Integer.parseInt(split[2]), (int)0, (int)65535, (String)"port");
    }

    public ConnectionParamSet() {
        this("Localhost", "localhost", 1099);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionParamSet)) {
            return false;
        }
        ConnectionParamSet other = (ConnectionParamSet)o;
        return this.description.equals(other.description) && this.host.equals(other.host) && this.port == other.port;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.description);
        hash = 23 * hash + Objects.hashCode(this.host);
        hash = 23 * hash + this.port;
        return hash;
    }

    public String toString() {
        return this.getDescription() + " - " + this.getHost() + ":" + this.getPort();
    }
}

