/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.persistence.v004;

import java.util.Comparator;
import org.opentcs.util.persistence.v004.LocationTO;
import org.opentcs.util.persistence.v004.PlantModelElementTO;
import org.opentcs.util.persistence.v004.PointTO;
import org.opentcs.util.persistence.v004.PropertyTO;

public final class Comparators {
    private static final Comparator<PlantModelElementTO> ELEMENTS_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private static final Comparator<PointTO.OutgoingPath> OUTGOING_PATHS_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());
    private static final Comparator<LocationTO.Link> LINKS_BY_POINT_NAME = (o1, o2) -> o1.getPoint().compareTo(o2.getPoint());
    private static final Comparator<PropertyTO> PROPERTIES_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName());

    private Comparators() {
    }

    public static Comparator<PlantModelElementTO> elementsByName() {
        return ELEMENTS_BY_NAME;
    }

    public static Comparator<PointTO.OutgoingPath> outgoingPathsByName() {
        return OUTGOING_PATHS_BY_NAME;
    }

    public static Comparator<LocationTO.Link> linksByPointName() {
        return LINKS_BY_POINT_NAME;
    }

    public static Comparator<PropertyTO> propertiesByName() {
        return PROPERTIES_BY_NAME;
    }
}

