/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.common;

import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.common.PortalManager;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.gui.dialog.ConnectToServerDialog;
import org.opentcs.util.gui.dialog.ConnectionParamSet;
import org.opentcs.util.gui.dialog.NullConnectionParamSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPortalManager
implements PortalManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPortalManager.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/common/Bundle");
    private final EventHandler eventHandler;
    private final List<ConnectionParamSet> connectionBookmarks;
    private final KernelServicePortal servicePortal;
    private ConnectionParamSet lastConnection = new NullConnectionParamSet();
    private ConnectionParamSet currentConnection = new NullConnectionParamSet();

    @Inject
    public DefaultPortalManager(KernelServicePortal servicePortal, @ApplicationEventBus EventHandler eventHandler, List<ConnectionParamSet> connectionBookmarks) {
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.connectionBookmarks = Objects.requireNonNull(connectionBookmarks, "connectionBookmarks");
    }

    @Override
    public boolean connect(PortalManager.ConnectionMode mode) {
        if (this.isConnected()) {
            return true;
        }
        switch (mode) {
            case AUTO: {
                if (this.connectionBookmarks.isEmpty()) {
                    LOG.info("Cannot connect automatically. No connection bookmarks available.");
                    return false;
                }
                ConnectionParamSet paramSet = this.connectionBookmarks.get(0);
                return this.connect(paramSet.getDescription(), paramSet.getHost(), paramSet.getPort());
            }
            case MANUAL: {
                return this.connectWithDialog();
            }
            case RECONNECT: {
                if (this.lastConnection instanceof NullConnectionParamSet) {
                    LOG.info("Cannot reconnect. No portal we were previously connected to.");
                    return false;
                }
                return this.connect(this.lastConnection.getDescription(), this.lastConnection.getHost(), this.lastConnection.getPort());
            }
        }
        LOG.warn("Unhandled connection mode '{}'. Not connecting.", (Object)mode.name());
        return false;
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.eventHandler.onEvent((Object)PortalManager.ConnectionState.DISCONNECTING);
        try {
            this.servicePortal.logout();
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Exception trying to disconnect from remote portal", (Throwable)e);
        }
        this.lastConnection = this.currentConnection;
        this.currentConnection = new NullConnectionParamSet();
        this.eventHandler.onEvent((Object)PortalManager.ConnectionState.DISCONNECTED);
    }

    @Override
    public boolean isConnected() {
        return !(this.currentConnection instanceof NullConnectionParamSet);
    }

    @Override
    public KernelServicePortal getPortal() {
        return this.servicePortal;
    }

    @Override
    public String getDescription() {
        return this.currentConnection.getDescription();
    }

    @Override
    public String getHost() {
        return this.currentConnection.getHost();
    }

    @Override
    public int getPort() {
        return this.currentConnection.getPort();
    }

    private boolean connect(String description, String host, int port) {
        try {
            this.eventHandler.onEvent((Object)PortalManager.ConnectionState.CONNECTING);
            this.servicePortal.login(host, port);
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Failed to connect to remote portal", (Throwable)e);
            this.eventHandler.onEvent((Object)PortalManager.ConnectionState.DISCONNECTED);
            JOptionPane.showMessageDialog(null, BUNDLE.getString("connectToServerDialog.optionPane_noConnection.message"), BUNDLE.getString("connectToServerDialog.optionPane_noConnection.message"), 0);
            return this.connectWithDialog();
        }
        this.currentConnection = new ConnectionParamSet(description, host, port);
        this.eventHandler.onEvent((Object)PortalManager.ConnectionState.CONNECTED);
        return true;
    }

    private boolean connectWithDialog() {
        ConnectToServerDialog dialog = new ConnectToServerDialog(this.connectionBookmarks);
        dialog.setVisible(true);
        if (dialog.getReturnStatus() == 1) {
            return this.connect(dialog.getDescription(), dialog.getHost(), dialog.getPort());
        }
        return false;
    }
}

