/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SingleLineFormatter
extends Formatter {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HH:mm:ss-SSS");
    private final Date date = new Date();
    private final String lineSeparator = System.getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord record) {
        this.date.setTime(record.getMillis());
        StringBuilder result = new StringBuilder();
        result.append('[').append(DATE_FORMAT.format(this.date)).append("] ").append(String.format("%1$-7.7s", record.getLevel().getName())).append(' ').append(String.format("%1$-20s", Thread.currentThread().getName())).append(' ').append(String.format("%1$-55s", this.source(record))).append(": ").append(this.formatMessage(record)).append(this.lineSeparator);
        if (record.getThrown() != null) {
            result.append(this.stackTrace(record.getThrown()));
            result.append(this.lineSeparator);
        }
        return result.toString();
    }

    private String source(LogRecord record) {
        return record.getSourceClassName() != null ? record.getSourceClassName().replaceAll("\\B\\w+(\\.[a-z])", "$1") + "." + record.getSourceMethodName() + "()" : record.getLoggerName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String stackTrace(Throwable thrown) {
        try (StringWriter sWriter = new StringWriter();){
            PrintWriter pWriter = new PrintWriter(sWriter);
            try {
                thrown.printStackTrace(pWriter);
                pWriter.flush();
                String string = sWriter.toString();
                pWriter.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            throw new IllegalStateException("Could not print stack trace for log output", exc);
        }
    }
}

