/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.persistence.v004;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentcs.access.to.model.BlockCreationTO;
import org.opentcs.access.to.model.LocationCreationTO;
import org.opentcs.access.to.model.LocationTypeCreationTO;
import org.opentcs.access.to.model.PathCreationTO;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.access.to.model.PointCreationTO;
import org.opentcs.access.to.model.VehicleCreationTO;
import org.opentcs.access.to.model.VisualLayoutCreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.data.model.Block;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.data.model.visualization.LocationRepresentation;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.util.Colors;
import org.opentcs.util.persistence.v004.AllowedOperationTO;
import org.opentcs.util.persistence.v004.AllowedPeripheralOperationTO;
import org.opentcs.util.persistence.v004.BlockTO;
import org.opentcs.util.persistence.v004.Comparators;
import org.opentcs.util.persistence.v004.LocationTO;
import org.opentcs.util.persistence.v004.LocationTypeTO;
import org.opentcs.util.persistence.v004.MemberTO;
import org.opentcs.util.persistence.v004.PathTO;
import org.opentcs.util.persistence.v004.PeripheralOperationTO;
import org.opentcs.util.persistence.v004.PointTO;
import org.opentcs.util.persistence.v004.PropertyTO;
import org.opentcs.util.persistence.v004.V004PlantModelTO;
import org.opentcs.util.persistence.v004.VehicleTO;
import org.opentcs.util.persistence.v004.VisualLayoutTO;

public class V004TOMapper {
    public static final String VERSION_STRING = "0.0.4";

    public PlantModelCreationTO map(V004PlantModelTO model) {
        PlantModelCreationTO result = new PlantModelCreationTO(model.getName()).withPoints(this.toPointCreationTO(model.getPoints())).withVehicles(this.toVehicleCreationTO(model.getVehicles())).withPaths(this.toPathCreationTO(model.getPaths())).withLocationTypes(this.toLocationTypeCreationTO(model.getLocationTypes())).withLocations(this.toLocationCreationTO(model.getLocations())).withBlocks(this.toBlockCreationTO(model.getBlocks())).withVisualLayout(this.toVisualLayoutCreationTO(model.getVisualLayout())).withProperties(this.convertProperties(model.getProperties()));
        return result;
    }

    public V004PlantModelTO map(PlantModelCreationTO model) {
        V004PlantModelTO result = new V004PlantModelTO();
        result.setName(model.getName());
        result.setVersion(VERSION_STRING);
        result.getPoints().addAll(this.toPointTO(model.getPoints(), model.getPaths()));
        result.getVehicles().addAll(this.toVehicleTO(model.getVehicles()));
        result.getPaths().addAll(this.toPathTO(model.getPaths()));
        result.getLocationTypes().addAll(this.toLocationTypeTO(model.getLocationTypes()));
        result.getLocations().addAll(this.toLocationTO(model.getLocations()));
        result.getBlocks().addAll(this.toBlockTO(model.getBlocks()));
        result.setVisualLayout(this.toVisualLayoutTO(model.getVisualLayout()));
        result.getProperties().addAll(this.convertProperties(model.getProperties()));
        return result;
    }

    private List<PointCreationTO> toPointCreationTO(List<PointTO> points) {
        ArrayList<PointCreationTO> result = new ArrayList<PointCreationTO>();
        for (PointTO point : points) {
            result.add(new PointCreationTO(point.getName()).withPosition(new Triple(point.getxPosition().longValue(), point.getyPosition().longValue(), point.getzPosition().longValue())).withVehicleOrientationAngle(point.getVehicleOrientationAngle().doubleValue()).withType(Point.Type.valueOf((String)point.getType())).withProperties(this.convertProperties(point.getProperties())).withLayout(new PointCreationTO.Layout(new Couple(point.getPointLayout().getxPosition().longValue(), point.getPointLayout().getyPosition().longValue()), new Couple(point.getPointLayout().getxLabelOffset().longValue(), point.getPointLayout().getyLabelOffset().longValue()), point.getPointLayout().getLayerId().intValue())));
        }
        return result;
    }

    private List<VehicleCreationTO> toVehicleCreationTO(List<VehicleTO> vehicles) {
        ArrayList<VehicleCreationTO> result = new ArrayList<VehicleCreationTO>();
        for (VehicleTO vehicle : vehicles) {
            result.add(new VehicleCreationTO(vehicle.getName()).withLength(vehicle.getLength().intValue()).withEnergyLevelCritical(vehicle.getEnergyLevelCritical().intValue()).withEnergyLevelGood(vehicle.getEnergyLevelGood().intValue()).withEnergyLevelFullyRecharged(vehicle.getEnergyLevelFullyRecharged().intValue()).withEnergyLevelSufficientlyRecharged(vehicle.getEnergyLevelSufficientlyRecharged().intValue()).withMaxReverseVelocity(vehicle.getMaxReverseVelocity()).withMaxVelocity(vehicle.getMaxVelocity()).withProperties(this.convertProperties(vehicle.getProperties())).withLayout(new VehicleCreationTO.Layout(Colors.decodeFromHexRGB(vehicle.getVehicleLayout().getColor()))));
        }
        return result;
    }

    private List<PathCreationTO> toPathCreationTO(List<PathTO> paths) {
        ArrayList<PathCreationTO> result = new ArrayList<PathCreationTO>();
        for (PathTO path : paths) {
            result.add(new PathCreationTO(path.getName(), path.getSourcePoint(), path.getDestinationPoint()).withLength(path.getLength().longValue()).withLocked(path.isLocked().booleanValue()).withMaxVelocity(path.getMaxVelocity().intValue()).withMaxReverseVelocity(path.getMaxReverseVelocity().intValue()).withPeripheralOperations(this.toPeripheralOperationCreationTOs(path.getPeripheralOperations())).withProperties(this.convertProperties(path.getProperties())).withLayout(new PathCreationTO.Layout(Path.Layout.ConnectionType.valueOf((String)path.getPathLayout().getConnectionType()), path.getPathLayout().getControlPoints().stream().map((? super T controlPoint) -> new Couple(controlPoint.getX().longValue(), controlPoint.getY().longValue())).collect(Collectors.toList()), path.getPathLayout().getLayerId().intValue())));
        }
        return result;
    }

    private List<PeripheralOperationCreationTO> toPeripheralOperationCreationTOs(List<PeripheralOperationTO> tos) {
        return tos.stream().map((? super T to) -> new PeripheralOperationCreationTO(to.getName(), to.getLocationName()).withExecutionTrigger(PeripheralOperation.ExecutionTrigger.valueOf((String)to.getExecutionTrigger())).withCompletionRequired(to.isCompletionRequired())).collect(Collectors.toList());
    }

    private List<LocationTypeCreationTO> toLocationTypeCreationTO(List<LocationTypeTO> locationTypes) {
        ArrayList<LocationTypeCreationTO> result = new ArrayList<LocationTypeCreationTO>();
        for (LocationTypeTO locationType : locationTypes) {
            result.add(new LocationTypeCreationTO(locationType.getName()).withAllowedOperations(this.getOperationNames(locationType.getAllowedOperations())).withAllowedPeripheralOperations(this.getPeripheralOperationNames(locationType.getAllowedPeripheralOperations())).withProperties(this.convertProperties(locationType.getProperties())).withLayout(new LocationTypeCreationTO.Layout(LocationRepresentation.valueOf((String)locationType.getLocationTypeLayout().getLocationRepresentation()))));
        }
        return result;
    }

    private List<LocationCreationTO> toLocationCreationTO(List<LocationTO> locations) {
        ArrayList<LocationCreationTO> result = new ArrayList<LocationCreationTO>();
        for (LocationTO location : locations) {
            result.add(new LocationCreationTO(location.getName(), location.getType(), new Triple(location.getxPosition().longValue(), location.getyPosition().longValue(), location.getzPosition().longValue())).withLinks(this.getLinks(location)).withLocked(location.isLocked().booleanValue()).withProperties(this.convertProperties(location.getProperties())).withLayout(new LocationCreationTO.Layout(new Couple(location.getLocationLayout().getxPosition().longValue(), location.getLocationLayout().getyPosition().longValue()), new Couple(location.getLocationLayout().getxLabelOffset().longValue(), location.getLocationLayout().getyLabelOffset().longValue()), LocationRepresentation.valueOf((String)location.getLocationLayout().getLocationRepresentation()), location.getLocationLayout().getLayerId().intValue())));
        }
        return result;
    }

    private List<BlockCreationTO> toBlockCreationTO(List<BlockTO> blocks) {
        ArrayList<BlockCreationTO> result = new ArrayList<BlockCreationTO>();
        for (BlockTO block : blocks) {
            result.add(new BlockCreationTO(block.getName()).withType(Block.Type.valueOf((String)block.getType())).withMemberNames(block.getMembers().stream().map((? super T member) -> member.getName()).collect(Collectors.toSet())).withProperties(this.convertProperties(block.getProperties())).withLayout(new BlockCreationTO.Layout(Colors.decodeFromHexRGB(block.getBlockLayout().getColor()))));
        }
        return result;
    }

    private VisualLayoutCreationTO toVisualLayoutCreationTO(VisualLayoutTO visualLayout) {
        return new VisualLayoutCreationTO(visualLayout.getName()).withScaleX((double)visualLayout.getScaleX().floatValue()).withScaleY((double)visualLayout.getScaleY().floatValue()).withLayers(this.convertLayers(visualLayout.getLayers())).withLayerGroups(this.convertLayerGroups(visualLayout.getLayerGroups())).withProperties(this.convertProperties(visualLayout.getProperties()));
    }

    private List<Layer> convertLayers(List<VisualLayoutTO.Layer> layers) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        for (VisualLayoutTO.Layer layer : layers) {
            result.add(new Layer(layer.getId().intValue(), layer.getOrdinal().intValue(), layer.isVisible().booleanValue(), layer.getName(), layer.getGroupId().intValue()));
        }
        return result;
    }

    private List<LayerGroup> convertLayerGroups(List<VisualLayoutTO.LayerGroup> layerGroups) {
        ArrayList<LayerGroup> result = new ArrayList<LayerGroup>();
        for (VisualLayoutTO.LayerGroup layerGroup : layerGroups) {
            result.add(new LayerGroup(layerGroup.getId().intValue(), layerGroup.getName(), layerGroup.isVisible().booleanValue()));
        }
        return result;
    }

    private Map<String, String> convertProperties(List<PropertyTO> propsList) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertyTO property : propsList) {
            String propName = this.isNullOrEmpty(property.getName()) ? "Property unknown" : property.getName();
            String propValue = this.isNullOrEmpty(property.getValue()) ? "Value unknown" : property.getValue();
            result.put(propName, propValue);
        }
        return result;
    }

    private List<String> getOperationNames(List<AllowedOperationTO> ops) {
        LinkedList<String> result = new LinkedList<String>();
        for (AllowedOperationTO operation : ops) {
            result.add(operation.getName());
        }
        return result;
    }

    private List<String> getPeripheralOperationNames(List<AllowedPeripheralOperationTO> ops) {
        LinkedList<String> result = new LinkedList<String>();
        for (AllowedPeripheralOperationTO operation : ops) {
            result.add(operation.getName());
        }
        return result;
    }

    private Map<String, Set<String>> getLinks(LocationTO to) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (LocationTO.Link linkTO : to.getLinks()) {
            result.put(linkTO.getPoint(), new HashSet<String>(this.getOperationNames(linkTO.getAllowedOperations())));
        }
        return result;
    }

    private List<PointTO> toPointTO(List<PointCreationTO> points, List<PathCreationTO> paths) {
        ArrayList<PointTO> result = new ArrayList<PointTO>();
        for (PointCreationTO point : points) {
            PointTO pointTO = new PointTO();
            pointTO.setName(point.getName());
            pointTO.setxPosition(point.getPosition().getX()).setyPosition(point.getPosition().getY()).setVehicleOrientationAngle(Float.valueOf((float)point.getVehicleOrientationAngle())).setType(point.getType().name()).setOutgoingPaths(this.getOutgoingPaths(point, paths)).setPointLayout(new PointTO.PointLayout().setxPosition(point.getLayout().getPosition().getX()).setyPosition(point.getLayout().getPosition().getY()).setxLabelOffset(point.getLayout().getLabelOffset().getX()).setyLabelOffset(point.getLayout().getLabelOffset().getY()).setLayerId(point.getLayout().getLayerId())).setProperties(this.convertProperties(point.getProperties()));
            result.add(pointTO);
        }
        Collections.sort(result, Comparators.elementsByName());
        return result;
    }

    private List<VehicleTO> toVehicleTO(List<VehicleCreationTO> vehicles) {
        ArrayList<VehicleTO> result = new ArrayList<VehicleTO>();
        for (VehicleCreationTO vehicle : vehicles) {
            VehicleTO vehicleTO = new VehicleTO();
            vehicleTO.setName(vehicle.getName());
            vehicleTO.setLength(Long.valueOf(vehicle.getLength())).setMaxVelocity(vehicle.getMaxVelocity()).setMaxReverseVelocity(vehicle.getMaxReverseVelocity()).setEnergyLevelGood(Long.valueOf(vehicle.getEnergyLevelGood())).setEnergyLevelCritical(Long.valueOf(vehicle.getEnergyLevelCritical())).setEnergyLevelFullyRecharged(Long.valueOf(vehicle.getEnergyLevelFullyRecharged())).setEnergyLevelSufficientlyRecharged(Long.valueOf(vehicle.getEnergyLevelSufficientlyRecharged())).setVehicleLayout(new VehicleTO.VehicleLayout().setColor(Colors.encodeToHexRGB(vehicle.getLayout().getRouteColor()))).setProperties(this.convertProperties(vehicle.getProperties()));
            result.add(vehicleTO);
        }
        Collections.sort(result, Comparators.elementsByName());
        return result;
    }

    private List<PathTO> toPathTO(List<PathCreationTO> paths) {
        ArrayList<PathTO> result = new ArrayList<PathTO>();
        for (PathCreationTO path : paths) {
            PathTO pathTO = new PathTO();
            pathTO.setName(path.getName());
            pathTO.setSourcePoint(path.getSrcPointName()).setDestinationPoint(path.getDestPointName()).setLength(path.getLength()).setMaxVelocity(Long.valueOf(path.getMaxVelocity())).setMaxReverseVelocity(Long.valueOf(path.getMaxReverseVelocity())).setPeripheralOperations(this.toPeripheralOperationTOs(path.getPeripheralOperations())).setLocked(path.isLocked()).setPathLayout(new PathTO.PathLayout().setConnectionType(path.getLayout().getConnectionType().name()).setControlPoints(path.getLayout().getControlPoints().stream().map((? super T controlPoint) -> new PathTO.ControlPoint().setX(controlPoint.getX()).setY(controlPoint.getY())).collect(Collectors.toList())).setLayerId(path.getLayout().getLayerId())).setProperties(this.convertProperties(path.getProperties()));
            result.add(pathTO);
        }
        Collections.sort(result, Comparators.elementsByName());
        return result;
    }

    private List<PeripheralOperationTO> toPeripheralOperationTOs(List<PeripheralOperationCreationTO> tos) {
        return tos.stream().map((? super T to) -> (PeripheralOperationTO)new PeripheralOperationTO().setLocationName(to.getLocationName()).setExecutionTrigger(to.getExecutionTrigger().name()).setCompletionRequired(to.isCompletionRequired()).setName(to.getOperation())).collect(Collectors.toList());
    }

    private List<LocationTypeTO> toLocationTypeTO(List<LocationTypeCreationTO> locationTypes) {
        ArrayList<LocationTypeTO> result = new ArrayList<LocationTypeTO>();
        for (LocationTypeCreationTO locationType : locationTypes) {
            LocationTypeTO locationTypeTO = new LocationTypeTO();
            locationTypeTO.setName(locationType.getName());
            locationTypeTO.setAllowedOperations(this.toAllowedOperationTOs(locationType.getAllowedOperations())).setAllowedPeripheralOperations(this.toAllowedPeripheralOperationTOs(locationType.getAllowedPeripheralOperations())).setLocationTypeLayout(new LocationTypeTO.LocationTypeLayout().setLocationRepresentation(locationType.getLayout().getLocationRepresentation().name())).setProperties(this.convertProperties(locationType.getProperties()));
            result.add(locationTypeTO);
        }
        Collections.sort(result, Comparators.elementsByName());
        return result;
    }

    private List<LocationTO> toLocationTO(List<LocationCreationTO> locations) {
        ArrayList<LocationTO> result = new ArrayList<LocationTO>();
        for (LocationCreationTO location : locations) {
            LocationTO locationTO = new LocationTO();
            locationTO.setName(location.getName());
            locationTO.setxPosition(location.getPosition().getX()).setyPosition(location.getPosition().getY()).setType(location.getTypeName()).setLinks(this.toLocationTOLinks(location.getLinks())).setLocked(location.isLocked()).setLocationLayout(new LocationTO.LocationLayout().setxPosition(location.getLayout().getPosition().getX()).setyPosition(location.getLayout().getPosition().getY()).setxLabelOffset(location.getLayout().getLabelOffset().getX()).setyLabelOffset(location.getLayout().getLabelOffset().getY()).setLocationRepresentation(location.getLayout().getLocationRepresentation().name()).setLayerId(location.getLayout().getLayerId())).setProperties(this.convertProperties(location.getProperties()));
            result.add(locationTO);
        }
        Collections.sort(result, Comparators.elementsByName());
        return result;
    }

    private List<BlockTO> toBlockTO(List<BlockCreationTO> blocks) {
        ArrayList<BlockTO> result = new ArrayList<BlockTO>();
        for (BlockCreationTO block : blocks) {
            BlockTO blockTO = new BlockTO();
            blockTO.setName(block.getName());
            blockTO.setType(block.getType().name()).setMembers(this.toMemberTOs(block.getMemberNames())).setBlockLayout(new BlockTO.BlockLayout().setColor(Colors.encodeToHexRGB(block.getLayout().getColor()))).setProperties(this.convertProperties(block.getProperties()));
            result.add(blockTO);
        }
        Collections.sort(result, Comparators.elementsByName());
        return result;
    }

    private VisualLayoutTO toVisualLayoutTO(VisualLayoutCreationTO layout) {
        VisualLayoutTO result = new VisualLayoutTO();
        result.setName(layout.getName()).setProperties(this.convertProperties(layout.getProperties()));
        result.setScaleX(Float.valueOf((float)layout.getScaleX())).setScaleY(Float.valueOf((float)layout.getScaleY())).setLayers(this.toLayerTOs(layout.getLayers())).setLayerGroups(this.toLayerGroupTOs(layout.getLayerGroups()));
        return result;
    }

    private List<VisualLayoutTO.Layer> toLayerTOs(List<Layer> layers) {
        ArrayList<VisualLayoutTO.Layer> result = new ArrayList<VisualLayoutTO.Layer>();
        for (Layer layer : layers) {
            result.add(new VisualLayoutTO.Layer().setId(layer.getId()).setOrdinal(layer.getOrdinal()).setVisible(layer.isVisible()).setName(layer.getName()).setGroupId(layer.getGroupId()));
        }
        return result;
    }

    private List<VisualLayoutTO.LayerGroup> toLayerGroupTOs(List<LayerGroup> layerGroups) {
        ArrayList<VisualLayoutTO.LayerGroup> result = new ArrayList<VisualLayoutTO.LayerGroup>();
        for (LayerGroup layerGroup : layerGroups) {
            result.add(new VisualLayoutTO.LayerGroup().setId(layerGroup.getId()).setName(layerGroup.getName()).setVisible(layerGroup.isVisible()));
        }
        return result;
    }

    private List<PointTO.OutgoingPath> getOutgoingPaths(PointCreationTO point, List<PathCreationTO> paths) {
        ArrayList<PointTO.OutgoingPath> result = new ArrayList<PointTO.OutgoingPath>();
        for (PathCreationTO path : paths) {
            if (!Objects.equals(path.getSrcPointName(), point.getName())) continue;
            result.add(new PointTO.OutgoingPath().setName(path.getName()));
        }
        Collections.sort(result, Comparators.outgoingPathsByName());
        return result;
    }

    private List<AllowedOperationTO> toAllowedOperationTOs(Collection<String> allowedOperations) {
        return allowedOperations.stream().sorted().map((? super T allowedOperation) -> (AllowedOperationTO)new AllowedOperationTO().setName((String)allowedOperation)).collect(Collectors.toList());
    }

    private List<AllowedPeripheralOperationTO> toAllowedPeripheralOperationTOs(Collection<String> allowedOperations) {
        return allowedOperations.stream().sorted().map((? super T allowedOperation) -> (AllowedPeripheralOperationTO)new AllowedPeripheralOperationTO().setName((String)allowedOperation)).collect(Collectors.toList());
    }

    private List<LocationTO.Link> toLocationTOLinks(Map<String, Set<String>> links) {
        ArrayList<LocationTO.Link> result = new ArrayList<LocationTO.Link>();
        links.forEach((key, value) -> result.add(new LocationTO.Link().setPoint((String)key).setAllowedOperations(this.toAllowedOperationTOs((Collection<String>)value))));
        Collections.sort(result, Comparators.linksByPointName());
        return result;
    }

    private List<MemberTO> toMemberTOs(Collection<String> members) {
        return members.stream().map((? super T member) -> (MemberTO)new MemberTO().setName((String)member)).sorted(Comparators.elementsByName()).collect(Collectors.toList());
    }

    private List<PropertyTO> convertProperties(Map<String, String> properties) {
        ArrayList<PropertyTO> result = new ArrayList<PropertyTO>();
        properties.forEach((key, value) -> result.add(new PropertyTO().setName((String)key).setValue((String)value)));
        Collections.sort(result, Comparators.propertiesByName());
        return result;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

