/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.statistics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opentcs.util.statistics.StatisticsRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsLogParser {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsLogParser.class);

    private StatisticsLogParser() {
    }

    public static List<StatisticsRecord> parseLog(File inputFile) throws FileNotFoundException, IOException {
        Objects.requireNonNull(inputFile, "inputFile");
        LinkedList<StatisticsRecord> result = new LinkedList<StatisticsRecord>();
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), Charset.forName("UTF-8")));){
            String inputLine = inputReader.readLine();
            while (inputLine != null) {
                StatisticsRecord record = StatisticsRecord.parseRecord(inputLine);
                if (record != null) {
                    result.add(record);
                }
                inputLine = inputReader.readLine();
            }
        }
        catch (IOException exc) {
            LOG.warn("Exception parsing input file", (Throwable)exc);
            throw exc;
        }
        return result;
    }
}

