/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.util.statistics;

import java.io.IOException;
import java.util.Objects;
import org.opentcs.util.Assertions;
import org.opentcs.util.statistics.StatisticsEvent;

public class StatisticsRecord {
    private static final String FIELD_SEPARATOR = "||";
    private static final String FIELD_SEPARATOR_REGEXP = "\\|\\|";
    private final long timestamp;
    private final StatisticsEvent event;
    private final String label;

    public StatisticsRecord(long timestamp, StatisticsEvent event, String label) {
        this.timestamp = timestamp;
        this.event = Objects.requireNonNull(event, "event");
        this.label = Objects.requireNonNull(label, "label");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public StatisticsEvent getEvent() {
        return this.event;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.timestamp + FIELD_SEPARATOR + this.event.name() + FIELD_SEPARATOR + this.label;
    }

    public static StatisticsRecord parseRecord(String input) throws IOException {
        Objects.requireNonNull(input, "input");
        Assertions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (String)"input is empty");
        String[] splitInput = input.split(FIELD_SEPARATOR_REGEXP, 3);
        if (splitInput.length < 3) {
            throw new IOException("Splitting '" + input + "' with '||' results in too few elements (" + splitInput.length + ").");
        }
        long timestamp = Long.parseLong(splitInput[0]);
        StatisticsEvent event = StatisticsEvent.valueOf(splitInput[1]);
        String label = splitInput[2];
        return new StatisticsRecord(timestamp, event, label);
    }
}

