/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import java.util.Objects;
import org.opentcs.access.Kernel;
import org.opentcs.components.Lifecycle;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.workingset.Model;
import org.opentcs.kernel.workingset.TCSObjectPool;

abstract class KernelState
implements Lifecycle {
    private final Object globalSyncObject;
    private final TCSObjectPool globalObjectPool;
    private final Model model;
    private final ModelPersister modelPersister;

    KernelState(Object globalSyncObject, TCSObjectPool objectPool, Model model, ModelPersister modelPersister) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.globalObjectPool = Objects.requireNonNull(objectPool, "objectPool");
        this.model = Objects.requireNonNull(model, "model");
        this.modelPersister = Objects.requireNonNull(modelPersister, "modelPersister");
    }

    public abstract Kernel.State getState();

    protected Object getGlobalSyncObject() {
        return this.globalSyncObject;
    }

    protected ModelPersister getModelPersister() {
        return this.modelPersister;
    }

    protected TCSObjectPool getGlobalObjectPool() {
        return this.globalObjectPool;
    }

    protected Model getModel() {
        return this.model;
    }
}

