/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import org.opentcs.kernel.KernelState;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.workingset.Model;
import org.opentcs.kernel.workingset.TCSObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KernelStateOnline
extends KernelState {
    private static final Logger LOG = LoggerFactory.getLogger(KernelStateOnline.class);
    private final boolean saveModelOnTerminate;

    public KernelStateOnline(Object globalSyncObject, TCSObjectPool objectPool, Model model, ModelPersister modelPersister, boolean saveModelOnTerminate) {
        super(globalSyncObject, objectPool, model, modelPersister);
        this.saveModelOnTerminate = saveModelOnTerminate;
    }

    public void terminate() {
        if (this.saveModelOnTerminate) {
            this.savePlantModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlantModel() throws IllegalStateException {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            this.getModelPersister().saveModel(this.getModel().createPlantModelCreationTO());
        }
    }
}

