/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.components.kernel.Dispatcher;
import org.opentcs.components.kernel.KernelExtension;
import org.opentcs.components.kernel.PeripheralJobDispatcher;
import org.opentcs.components.kernel.Router;
import org.opentcs.components.kernel.Scheduler;
import org.opentcs.components.kernel.services.InternalVehicleService;
import org.opentcs.customizations.kernel.ActiveInOperatingMode;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.customizations.kernel.KernelExecutor;
import org.opentcs.data.model.Vehicle;
import org.opentcs.kernel.KernelApplicationConfiguration;
import org.opentcs.kernel.KernelStateOnline;
import org.opentcs.kernel.OrderCleanerTask;
import org.opentcs.kernel.extensions.controlcenter.vehicles.AttachmentManager;
import org.opentcs.kernel.peripherals.LocalPeripheralControllerPool;
import org.opentcs.kernel.peripherals.PeripheralAttachmentManager;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.vehicles.LocalVehicleControllerPool;
import org.opentcs.kernel.workingset.Model;
import org.opentcs.kernel.workingset.PeripheralJobPool;
import org.opentcs.kernel.workingset.TCSObjectPool;
import org.opentcs.kernel.workingset.TransportOrderPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KernelStateOperating
extends KernelStateOnline {
    private static final Logger LOG = LoggerFactory.getLogger(KernelStateOperating.class);
    private final KernelApplicationConfiguration configuration;
    private final TransportOrderPool orderPool;
    private final PeripheralJobPool jobPool;
    private final Router router;
    private final Scheduler scheduler;
    private final Dispatcher dispatcher;
    private final PeripheralJobDispatcher peripheralJobDispatcher;
    private final LocalVehicleControllerPool vehicleControllerPool;
    private final LocalPeripheralControllerPool peripheralControllerPool;
    private final ScheduledExecutorService kernelExecutor;
    private final OrderCleanerTask orderCleanerTask;
    private final Set<KernelExtension> extensions;
    private final AttachmentManager attachmentManager;
    private final PeripheralAttachmentManager peripheralAttachmentManager;
    private final InternalVehicleService vehicleService;
    private ScheduledFuture<?> cleanerTaskFuture;
    private boolean initialized;

    @Inject
    KernelStateOperating(@GlobalSyncObject Object globalSyncObject, TCSObjectPool objectPool, Model model, TransportOrderPool orderPool, PeripheralJobPool jobPool, ModelPersister modelPersister, KernelApplicationConfiguration configuration, Router router, Scheduler scheduler, Dispatcher dispatcher, PeripheralJobDispatcher peripheralJobDispatcher, LocalVehicleControllerPool controllerPool, LocalPeripheralControllerPool peripheralControllerPool, @KernelExecutor ScheduledExecutorService kernelExecutor, OrderCleanerTask orderCleanerTask, @ActiveInOperatingMode Set<KernelExtension> extensions, AttachmentManager attachmentManager, PeripheralAttachmentManager peripheralAttachmentManager, InternalVehicleService vehicleService) {
        super(globalSyncObject, objectPool, model, modelPersister, configuration.saveModelOnTerminateOperating());
        this.orderPool = Objects.requireNonNull(orderPool, "orderPool");
        this.jobPool = Objects.requireNonNull(jobPool, "jobPool");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.router = Objects.requireNonNull(router, "router");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
        this.peripheralJobDispatcher = Objects.requireNonNull(peripheralJobDispatcher, "peripheralJobDispatcher");
        this.vehicleControllerPool = Objects.requireNonNull(controllerPool, "controllerPool");
        this.peripheralControllerPool = Objects.requireNonNull(peripheralControllerPool, "peripheralControllerPool");
        this.kernelExecutor = Objects.requireNonNull(kernelExecutor, "kernelExecutor");
        this.orderCleanerTask = Objects.requireNonNull(orderCleanerTask, "orderCleanerTask");
        this.extensions = Objects.requireNonNull(extensions, "extensions");
        this.attachmentManager = Objects.requireNonNull(attachmentManager, "attachmentManager");
        this.peripheralAttachmentManager = Objects.requireNonNull(peripheralAttachmentManager, "peripheralAttachmentManager");
        this.vehicleService = Objects.requireNonNull(vehicleService, "vehicleService");
    }

    public void initialize() {
        if (this.initialized) {
            LOG.debug("Already initialized.");
            return;
        }
        LOG.debug("Initializing operating state...");
        for (Vehicle curVehicle : this.vehicleService.fetchObjects(Vehicle.class)) {
            this.vehicleService.updateVehicleProcState(curVehicle.getReference(), Vehicle.ProcState.IDLE);
            this.vehicleService.updateVehicleIntegrationLevel(curVehicle.getReference(), Vehicle.IntegrationLevel.TO_BE_RESPECTED);
            this.vehicleService.updateVehicleState(curVehicle.getReference(), Vehicle.State.UNKNOWN);
            this.vehicleService.updateVehicleTransportOrder(curVehicle.getReference(), null);
            this.vehicleService.updateVehicleOrderSequence(curVehicle.getReference(), null);
        }
        LOG.debug("Initializing scheduler '{}'...", (Object)this.scheduler);
        this.scheduler.initialize();
        LOG.debug("Initializing router '{}'...", (Object)this.router);
        this.router.initialize();
        LOG.debug("Initializing dispatcher '{}'...", (Object)this.dispatcher);
        this.dispatcher.initialize();
        LOG.debug("Initializing peripheral job dispatcher '{}'...", (Object)this.peripheralJobDispatcher);
        this.peripheralJobDispatcher.initialize();
        LOG.debug("Initializing vehicle controller pool '{}'...", (Object)this.vehicleControllerPool);
        this.vehicleControllerPool.initialize();
        LOG.debug("Initializing peripheral controller pool '{}'...", (Object)this.peripheralControllerPool);
        this.peripheralControllerPool.initialize();
        LOG.debug("Initializing attachment manager '{}'...", (Object)this.attachmentManager);
        this.attachmentManager.initialize();
        LOG.debug("Initializing peripheral attachment manager '{}'...", (Object)this.peripheralAttachmentManager);
        this.peripheralAttachmentManager.initialize();
        this.cleanerTaskFuture = this.kernelExecutor.scheduleAtFixedRate(this.orderCleanerTask, this.orderCleanerTask.getSweepInterval(), this.orderCleanerTask.getSweepInterval(), TimeUnit.MILLISECONDS);
        for (KernelExtension extension : this.extensions) {
            LOG.debug("Initializing kernel extension '{}'...", (Object)extension);
            extension.initialize();
        }
        LOG.debug("Finished initializing kernel extensions.");
        this.initialized = true;
        LOG.debug("Operating state initialized.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void terminate() {
        if (!this.initialized) {
            LOG.debug("Not initialized.");
            return;
        }
        LOG.debug("Terminating operating state...");
        super.terminate();
        for (KernelExtension extension : this.extensions) {
            LOG.debug("Terminating kernel extension '{}'...", (Object)extension);
            extension.terminate();
        }
        LOG.debug("Terminated kernel extensions.");
        this.cleanerTaskFuture.cancel(false);
        this.cleanerTaskFuture = null;
        LOG.debug("Terminating peripheral job dispatcher '{}'...", (Object)this.peripheralJobDispatcher);
        this.peripheralJobDispatcher.terminate();
        LOG.debug("Terminating dispatcher '{}'...", (Object)this.dispatcher);
        this.dispatcher.terminate();
        LOG.debug("Terminating router '{}'...", (Object)this.router);
        this.router.terminate();
        LOG.debug("Terminating scheduler '{}'...", (Object)this.scheduler);
        this.scheduler.terminate();
        LOG.debug("Terminating peripheral controller pool '{}'...", (Object)this.peripheralControllerPool);
        this.peripheralControllerPool.terminate();
        LOG.debug("Terminating vehicle controller pool '{}'...", (Object)this.vehicleControllerPool);
        this.vehicleControllerPool.terminate();
        LOG.debug("Terminating attachment manager '{}'...", (Object)this.attachmentManager);
        this.attachmentManager.terminate();
        LOG.debug("Terminating peripheral attachment manager '{}'...", (Object)this.peripheralAttachmentManager);
        this.peripheralAttachmentManager.terminate();
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        for (Vehicle curVehicle : this.vehicleService.fetchObjects(Vehicle.class)) {
            this.vehicleService.updateVehicleProcState(curVehicle.getReference(), Vehicle.ProcState.IDLE);
            this.vehicleService.updateVehicleIntegrationLevel(curVehicle.getReference(), Vehicle.IntegrationLevel.TO_BE_RESPECTED);
            this.vehicleService.updateVehicleState(curVehicle.getReference(), Vehicle.State.UNKNOWN);
            this.vehicleService.updateVehicleTransportOrder(curVehicle.getReference(), null);
            this.vehicleService.updateVehicleOrderSequence(curVehicle.getReference(), null);
        }
        this.orderPool.clear();
        this.jobPool.clear();
        this.initialized = false;
        LOG.debug("Operating state terminated.");
    }

    @Override
    public Kernel.State getState() {
        return Kernel.State.OPERATING;
    }
}

