/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelStateTransitionEvent;
import org.opentcs.access.LocalKernel;
import org.opentcs.components.kernel.KernelExtension;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.kernel.KernelExecutor;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.kernel.KernelState;
import org.opentcs.util.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardKernel
implements LocalKernel,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StandardKernel.class);
    private final Map<Kernel.State, Provider<KernelState>> stateProviders;
    private final EventBus eventBus;
    private final ScheduledExecutorService kernelExecutor;
    private final Set<KernelExtension> kernelExtensions = new HashSet<KernelExtension>();
    private final Semaphore terminationSemaphore = new Semaphore(0);
    private final NotificationService notificationService;
    private volatile boolean initialized;
    private KernelState kernelState;

    @Inject
    StandardKernel(@ApplicationEventBus EventBus eventBus, @KernelExecutor ScheduledExecutorService kernelExecutor, Map<Kernel.State, Provider<KernelState>> stateProviders, NotificationService notificationService) {
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.kernelExecutor = Objects.requireNonNull(kernelExecutor, "kernelExecutor");
        this.stateProviders = Objects.requireNonNull(stateProviders, "stateProviders");
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        for (KernelExtension extension : this.kernelExtensions) {
            LOG.debug("Initializing extension: {}", (Object)extension.getClass().getName());
            extension.initialize();
        }
        this.setState(Kernel.State.MODELLING);
        this.initialized = true;
        LOG.debug("Starting kernel thread");
        Thread kernelThread = new Thread((Runnable)this, "kernelThread");
        kernelThread.start();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.initialized = false;
        this.terminationSemaphore.release();
    }

    @Override
    public void run() {
        this.terminationSemaphore.acquireUninterruptibly();
        LOG.info("Terminating...");
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        LOG.debug("Shutting down kernel extensions...");
        for (KernelExtension extension : this.kernelExtensions) {
            extension.terminate();
        }
        this.kernelExecutor.shutdown();
        LOG.info("Kernel thread finished.");
    }

    public Kernel.State getState() {
        return this.kernelState.getState();
    }

    public void setState(Kernel.State newState) throws IllegalArgumentException {
        Kernel.State oldState;
        Objects.requireNonNull(newState, "newState");
        if (this.kernelState != null) {
            oldState = this.kernelState.getState();
            if (oldState == newState) {
                LOG.debug("Already in state '{}', doing nothing.", (Object)newState.name());
                return;
            }
            this.emitStateEvent(oldState, newState, false);
            this.kernelState.terminate();
        } else {
            oldState = null;
        }
        LOG.info("Switching kernel to state '{}'", (Object)newState.name());
        switch (newState) {
            case SHUTDOWN: {
                this.kernelState = (KernelState)this.stateProviders.get(Kernel.State.SHUTDOWN).get();
                this.kernelState.initialize();
                this.terminate();
                break;
            }
            case MODELLING: {
                this.kernelState = (KernelState)this.stateProviders.get(Kernel.State.MODELLING).get();
                this.kernelState.initialize();
                break;
            }
            case OPERATING: {
                this.kernelState = (KernelState)this.stateProviders.get(Kernel.State.OPERATING).get();
                this.kernelState.initialize();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected state: " + newState);
            }
        }
        this.emitStateEvent(oldState, newState, true);
        this.notificationService.publishUserNotification(new UserNotification("Kernel is now in state " + newState, UserNotification.Level.INFORMATIONAL));
    }

    public void addKernelExtension(KernelExtension newExtension) {
        Objects.requireNonNull(newExtension, "newExtension");
        this.kernelExtensions.add(newExtension);
    }

    public void removeKernelExtension(KernelExtension rmExtension) {
        Objects.requireNonNull(rmExtension, "rmExtension");
        this.kernelExtensions.remove(rmExtension);
    }

    private void emitStateEvent(Kernel.State leftState, Kernel.State enteredState, boolean transitionFinished) {
        this.eventBus.onEvent((Object)new KernelStateTransitionEvent(leftState, enteredState, transitionFinished));
    }
}

