/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.peripherals;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.components.Lifecycle;
import org.opentcs.data.model.Location;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterFactory;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralCommAdapterRegistry
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralCommAdapterRegistry.class);
    private final Map<PeripheralCommAdapterDescription, PeripheralCommAdapterFactory> factories = new HashMap<PeripheralCommAdapterDescription, PeripheralCommAdapterFactory>();
    private boolean initialized;

    @Inject
    public PeripheralCommAdapterRegistry(Set<PeripheralCommAdapterFactory> factories) {
        Objects.requireNonNull(factories, "factories");
        for (PeripheralCommAdapterFactory factory : factories) {
            LOG.info("Setting up peripheral communication adapter factory: {}", (Object)factory.getClass().getName());
            this.factories.put(factory.getDescription(), factory);
        }
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        for (PeripheralCommAdapterFactory factory : this.factories.values()) {
            factory.initialize();
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.initialized) {
            return;
        }
        for (PeripheralCommAdapterFactory factory : this.factories.values()) {
            factory.terminate();
        }
        this.initialized = false;
    }

    public List<PeripheralCommAdapterFactory> getFactories() {
        return new LinkedList<PeripheralCommAdapterFactory>(this.factories.values());
    }

    @Nonnull
    public PeripheralCommAdapterFactory findFactoryFor(@Nonnull PeripheralCommAdapterDescription description) {
        Objects.requireNonNull(description, "description");
        Assertions.checkArgument((this.factories.get(description) != null ? 1 : 0) != 0, (String)"No factory for description %s", (Object[])new Object[]{description});
        return this.factories.get(description);
    }

    public List<PeripheralCommAdapterFactory> findFactoriesFor(Location location) {
        Objects.requireNonNull(location, "location");
        return this.factories.values().stream().filter(factory -> factory.providesAdapterFor(location)).collect(Collectors.toList());
    }
}

