/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.persistence;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.customizations.ApplicationHome;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.util.Assertions;
import org.opentcs.util.FileSystems;
import org.opentcs.util.persistence.ModelParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLFileModelPersister
implements ModelPersister {
    private static final Logger LOG = LoggerFactory.getLogger(XMLFileModelPersister.class);
    private static final String MODEL_FILE_NAME = "model.xml";
    private final File dataDirectory;
    private final File modelFile;
    private final ModelParser modelParser;

    @Inject
    public XMLFileModelPersister(@ApplicationHome File directory, ModelParser modelParser) {
        this.modelParser = Objects.requireNonNull(modelParser, "modelParser");
        this.dataDirectory = new File(Objects.requireNonNull(directory, "directory"), "data");
        this.modelFile = new File(this.dataDirectory, MODEL_FILE_NAME);
    }

    @Override
    public Optional<String> getPersistentModelName() throws IllegalStateException {
        if (!this.hasSavedModel()) {
            return Optional.empty();
        }
        return Optional.of(this.readXMLModelName(this.modelFile));
    }

    @Override
    public void saveModel(PlantModelCreationTO model) throws IllegalStateException {
        Objects.requireNonNull(model, "model");
        LOG.debug("Saving model '{}'.", (Object)model.getName());
        Assertions.checkState((this.dataDirectory.isDirectory() || this.dataDirectory.mkdirs() ? 1 : 0) != 0, (String)"%s is not an existing directory and could not be created, either.", (Object[])new Object[]{this.dataDirectory.getPath()});
        Assertions.checkState((!this.modelFile.exists() || this.modelFile.isFile() ? 1 : 0) != 0, (String)"%s exists, but is not a regular file", (Object[])new Object[]{this.modelFile.getPath()});
        try {
            if (this.modelFile.exists()) {
                this.createBackup();
            }
            this.modelParser.writeModel(model, this.modelFile);
        }
        catch (IOException exc) {
            throw new IllegalStateException("Exception saving model", exc);
        }
    }

    @Override
    public PlantModelCreationTO readModel() throws IllegalStateException {
        if (!this.hasSavedModel()) {
            return new PlantModelCreationTO("empty model");
        }
        return this.readXMLModel(this.modelFile);
    }

    @Override
    public boolean hasSavedModel() {
        return this.modelFileExists();
    }

    private void createBackup() throws IOException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
        String time = sdf.format(cal.getTime());
        String modelBackupName = "model.xml_backup_" + time;
        File modelBackupDirectory = new File(this.dataDirectory, "backups");
        if (modelBackupDirectory.exists()) {
            if (!modelBackupDirectory.isDirectory()) {
                throw new IOException(modelBackupDirectory.getPath() + " exists, but is not a directory");
            }
        } else if (!modelBackupDirectory.mkdir()) {
            throw new IOException("Could not create model directory " + modelBackupDirectory.getPath());
        }
        Files.copy(this.modelFile.toPath(), new File(modelBackupDirectory, modelBackupName).toPath(), new CopyOption[0]);
    }

    private boolean modelFileExists() {
        if (!this.modelFile.exists()) {
            return false;
        }
        return this.modelFile.isFile();
    }

    @Override
    public void removeModel() throws IllegalStateException {
        LOG.debug("Removing model...");
        if (!this.modelFileExists()) {
            return;
        }
        try {
            this.createBackup();
            if (!FileSystems.deleteRecursively((File)this.modelFile)) {
                throw new IOException("Cannot delete " + this.modelFile.getPath());
            }
        }
        catch (IOException exc) {
            throw new IllegalStateException("Exception removing model", exc);
        }
    }

    private String readXMLModelName(File modelFile) throws IllegalStateException {
        return Optional.ofNullable(Strings.emptyToNull((String)this.readXMLModel(modelFile).getName())).orElse("ModelNameMissing");
    }

    private PlantModelCreationTO readXMLModel(File modelFile) throws IllegalStateException {
        try {
            return this.modelParser.readModel(modelFile);
        }
        catch (IOException exc) {
            LOG.error("Exception parsing input", (Throwable)exc);
            throw new IllegalStateException("Exception parsing input", exc);
        }
    }
}

