/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.components.kernel.Dispatcher;
import org.opentcs.components.kernel.services.DispatcherService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.kernel.workingset.TCSObjectPool;

public class StandardDispatcherService
implements DispatcherService {
    private final Object globalSyncObject;
    private final TCSObjectPool globalObjectPool;
    private final Dispatcher dispatcher;

    @Inject
    public StandardDispatcherService(@GlobalSyncObject Object globalSyncObject, TCSObjectPool globalObjectPool, Dispatcher dispatcher) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.globalObjectPool = Objects.requireNonNull(globalObjectPool, "globalObjectPool");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdrawByVehicle(TCSObjectReference<Vehicle> ref, boolean immediateAbort) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.withdrawOrder(this.globalObjectPool.getObject(Vehicle.class, ref), immediateAbort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdrawByTransportOrder(TCSObjectReference<TransportOrder> ref, boolean immediateAbort) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.dispatcher.withdrawOrder(this.globalObjectPool.getObject(TransportOrder.class, ref), immediateAbort);
        }
    }
}

