/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.kernel.workingset.NotificationBuffer;

public class StandardNotificationService
implements NotificationService {
    private final Object globalSyncObject;
    private final NotificationBuffer notificationBuffer;

    @Inject
    public StandardNotificationService(@GlobalSyncObject Object globalSyncObject, NotificationBuffer notificationBuffer) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.notificationBuffer = Objects.requireNonNull(notificationBuffer, "notificationBuffer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserNotification> fetchUserNotifications(Predicate<UserNotification> predicate) {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.notificationBuffer.getNotifications(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishUserNotification(UserNotification notification) {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.notificationBuffer.addNotification(notification);
        }
    }
}

