/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.to.peripherals.PeripheralJobCreationTO;
import org.opentcs.components.kernel.services.InternalPeripheralJobService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.workingset.PeripheralJobPool;

public class StandardPeripheralJobService
extends AbstractTCSObjectService
implements InternalPeripheralJobService {
    private final Object globalSyncObject;
    private final PeripheralJobPool jobPool;

    @Inject
    public StandardPeripheralJobService(TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, PeripheralJobPool jobPool) {
        super(objectService);
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.jobPool = Objects.requireNonNull(jobPool, "jobPool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeripheralJobState(TCSObjectReference<PeripheralJob> ref, PeripheralJob.State state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.jobPool.setPeripheralJobState(ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeripheralJob createPeripheralJob(PeripheralJobCreationTO to) throws ObjectUnknownException, ObjectExistsException, KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.jobPool.createPeripheralJob(to);
        }
    }
}

