/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.LocalKernel;
import org.opentcs.access.ModelTransitionEvent;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.components.kernel.services.InternalPlantModelService;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.kernel.persistence.ModelPersister;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.workingset.Model;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardPlantModelService
extends AbstractTCSObjectService
implements InternalPlantModelService {
    private static final Logger LOG = LoggerFactory.getLogger(StandardPlantModelService.class);
    private final Kernel kernel;
    private final Object globalSyncObject;
    private final Model model;
    private final ModelPersister modelPersister;
    private final EventHandler eventHandler;
    private final NotificationService notificationService;

    @Inject
    public StandardPlantModelService(LocalKernel kernel, TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, Model model, ModelPersister modelPersister, @ApplicationEventBus EventHandler eventHandler, NotificationService notificationService) {
        super(objectService);
        this.kernel = (Kernel)Objects.requireNonNull(kernel, "kernel");
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.model = Objects.requireNonNull(model, "model");
        this.modelPersister = Objects.requireNonNull(modelPersister, "modelPersister");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TCSResource<?>> expandResources(Set<TCSResourceReference<?>> resources) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.model.expandResources(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlantModel() throws IllegalStateException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            if (!this.modelPersister.hasSavedModel()) {
                this.createPlantModel(new PlantModelCreationTO("unnamed"));
                return;
            }
            String oldModelName = this.getModelName();
            PlantModelCreationTO modelCreationTO = this.modelPersister.readModel();
            String newModelName = Strings.isNullOrEmpty((String)modelCreationTO.getName()) ? "" : modelCreationTO.getName();
            this.emitModelEvent(oldModelName, newModelName, true, false);
            this.model.createPlantModelObjects(modelCreationTO);
            this.emitModelEvent(oldModelName, newModelName, true, true);
            this.notificationService.publishUserNotification(new UserNotification("Kernel loaded model " + newModelName, UserNotification.Level.INFORMATIONAL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePlantModel() throws IllegalStateException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.modelPersister.saveModel(this.model.createPlantModelCreationTO());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPlantModel(PlantModelCreationTO to) throws ObjectUnknownException, ObjectExistsException, IllegalStateException {
        boolean kernelInOperating;
        boolean bl = kernelInOperating = this.kernel.getState() == Kernel.State.OPERATING;
        if (kernelInOperating) {
            this.kernel.setState(Kernel.State.MODELLING);
        }
        String oldModelName = this.getModelName();
        this.emitModelEvent(oldModelName, to.getName(), true, false);
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.createPlantModelObjects(to);
        }
        this.savePlantModel();
        if (kernelInOperating) {
            this.kernel.setState(Kernel.State.OPERATING);
        }
        this.emitModelEvent(oldModelName, to.getName(), true, true);
        this.notificationService.publishUserNotification(new UserNotification("Kernel created model " + to.getName(), UserNotification.Level.INFORMATIONAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelName() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.model.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getModelProperties() throws KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.model.getProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocationLock(TCSObjectReference<Location> ref, boolean locked) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setLocationLocked(ref, locked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateLocationReservationToken(TCSObjectReference<Location> ref, String token) throws ObjectUnknownException, KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setLocationReservationToken(ref, token);
        }
    }

    private void emitModelEvent(String oldModelName, String newModelName, boolean modelContentChanged, boolean transitionFinished) {
        Objects.requireNonNull(newModelName, "newModelName");
        this.eventHandler.onEvent((Object)new ModelTransitionEvent(oldModelName, newModelName, modelContentChanged, transitionFinished));
    }
}

