/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.components.kernel.Query;
import org.opentcs.components.kernel.QueryResponder;
import org.opentcs.components.kernel.services.InternalQueryService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.util.Assertions;

public class StandardQueryService
implements InternalQueryService {
    private final Object globalSyncObject;
    private final Map<Class<? extends Query<?>>, QueryResponder> respondersByQueryType = new HashMap();

    @Inject
    public StandardQueryService(@GlobalSyncObject Object globalSyncObject) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(Query<T> query) {
        Objects.requireNonNull(query, "query");
        Object object = this.globalSyncObject;
        synchronized (object) {
            QueryResponder responder = this.respondersByQueryType.get(query.getClass());
            Assertions.checkArgument((responder != null ? 1 : 0) != 0, (String)"Query class not taken: %s", (Object[])new Object[]{query.getClass().getName()});
            return (T)responder.query(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponder(@Nonnull Class<? extends Query<?>> clazz, @Nonnull QueryResponder responder) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(responder, "responder");
        Object object = this.globalSyncObject;
        synchronized (object) {
            Assertions.checkArgument((!this.respondersByQueryType.containsKey(clazz) ? 1 : 0) != 0, (String)"Query class already taken: %s", (Object[])new Object[]{clazz.getName()});
            this.respondersByQueryType.put(clazz, responder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResponder(@Nonnull Class<? extends Query<?>> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.respondersByQueryType.remove(clazz);
        }
    }
}

