/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.LocalKernel;
import org.opentcs.components.kernel.Dispatcher;
import org.opentcs.components.kernel.Router;
import org.opentcs.components.kernel.services.RouterService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Path;
import org.opentcs.kernel.KernelApplicationConfiguration;
import org.opentcs.kernel.workingset.Model;

public class StandardRouterService
implements RouterService {
    private final Object globalSyncObject;
    private final LocalKernel kernel;
    private final Router router;
    private final Dispatcher dispatcher;
    private final Model model;
    private final KernelApplicationConfiguration configuration;

    @Inject
    public StandardRouterService(@GlobalSyncObject Object globalSyncObject, LocalKernel kernel, Router router, Dispatcher dispatcher, Model model, KernelApplicationConfiguration configuration) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.kernel = Objects.requireNonNull(kernel, "kernel");
        this.router = Objects.requireNonNull(router, "router");
        this.dispatcher = Objects.requireNonNull(dispatcher, "dispatcher");
        this.model = Objects.requireNonNull(model, "model");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePathLock(TCSObjectReference<Path> ref, boolean locked) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setPathLocked(ref, locked);
            if (this.kernel.getState() == Kernel.State.OPERATING && this.configuration.updateRoutingTopologyOnPathLockChange()) {
                this.updateRoutingTopology();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRoutingTopology() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.router.topologyChanged();
            this.dispatcher.topologyChanged();
        }
    }
}

