/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.kernel.workingset.TCSObjectPool;

public class StandardTCSObjectService
implements TCSObjectService {
    private final Object globalSyncObject;
    private final TCSObjectPool globalObjectPool;

    @Inject
    public StandardTCSObjectService(@GlobalSyncObject Object globalSyncObject, TCSObjectPool globalObjectPool) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.globalObjectPool = Objects.requireNonNull(globalObjectPool, "globalObjectPool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TCSObject<T>> T fetchObject(Class<T> clazz, TCSObjectReference<T> ref) {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            return this.getGlobalObjectPool().getObjectOrNull(clazz, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TCSObject<T>> T fetchObject(Class<T> clazz, String name) {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            return this.getGlobalObjectPool().getObjectOrNull(clazz, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TCSObject<T>> Set<T> fetchObjects(Class<T> clazz) {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            Set<T> objects = this.getGlobalObjectPool().getObjects(clazz);
            HashSet<TCSObject> copies = new HashSet<TCSObject>();
            for (TCSObject object2 : objects) {
                copies.add(object2);
            }
            return copies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TCSObject<T>> Set<T> fetchObjects(@Nonnull Class<T> clazz, @Nonnull Predicate<? super T> predicate) {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            return this.getGlobalObjectPool().getObjects(clazz, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjectProperty(TCSObjectReference<?> ref, String key, @Nullable String value) throws ObjectUnknownException {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            this.getGlobalObjectPool().setObjectProperty(ref, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendObjectHistoryEntry(TCSObjectReference<?> ref, ObjectHistory.Entry entry) throws ObjectUnknownException {
        Object object = this.getGlobalSyncObject();
        synchronized (object) {
            this.getGlobalObjectPool().appendObjectHistoryEntry(ref, entry);
        }
    }

    protected Object getGlobalSyncObject() {
        return this.globalSyncObject;
    }

    protected TCSObjectPool getGlobalObjectPool() {
        return this.globalObjectPool;
    }
}

