/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.components.kernel.services.InternalVehicleService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.LoadHandlingDevice;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.kernel.extensions.controlcenter.vehicles.AttachmentManager;
import org.opentcs.kernel.extensions.controlcenter.vehicles.VehicleEntry;
import org.opentcs.kernel.extensions.controlcenter.vehicles.VehicleEntryPool;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.vehicles.LocalVehicleControllerPool;
import org.opentcs.kernel.vehicles.VehicleCommAdapterRegistry;
import org.opentcs.kernel.workingset.Model;
import org.opentcs.kernel.workingset.TCSObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardVehicleService
extends AbstractTCSObjectService
implements InternalVehicleService {
    private static final Logger LOG = LoggerFactory.getLogger(StandardVehicleService.class);
    private final Object globalSyncObject;
    private final TCSObjectPool globalObjectPool;
    private final LocalVehicleControllerPool vehicleControllerPool;
    private final VehicleEntryPool vehicleEntryPool;
    private final AttachmentManager attachmentManager;
    private final VehicleCommAdapterRegistry commAdapterRegistry;
    private final Model model;

    @Inject
    public StandardVehicleService(TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, TCSObjectPool globalObjectPool, LocalVehicleControllerPool vehicleControllerPool, VehicleEntryPool vehicleEntryPool, AttachmentManager attachmentManager, VehicleCommAdapterRegistry commAdapterRegistry, Model model) {
        super(objectService);
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.globalObjectPool = Objects.requireNonNull(globalObjectPool, "globalObjectPool");
        this.vehicleControllerPool = Objects.requireNonNull(vehicleControllerPool, "vehicleControllerPool");
        this.vehicleEntryPool = Objects.requireNonNull(vehicleEntryPool, "vehicleEntryPool");
        this.attachmentManager = Objects.requireNonNull(attachmentManager, "attachmentManager");
        this.commAdapterRegistry = Objects.requireNonNull(commAdapterRegistry, "commAdapterRegistry");
        this.model = Objects.requireNonNull(model, "model");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleEnergyLevel(TCSObjectReference<Vehicle> ref, int energyLevel) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleEnergyLevel(ref, energyLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleLoadHandlingDevices(TCSObjectReference<Vehicle> ref, List<LoadHandlingDevice> devices) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleLoadHandlingDevices(ref, devices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleNextPosition(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<Point> pointRef) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleNextPosition(vehicleRef, pointRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleOrderSequence(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<OrderSequence> sequenceRef) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleOrderSequence(vehicleRef, sequenceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleOrientationAngle(TCSObjectReference<Vehicle> ref, double angle) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleOrientationAngle(ref, angle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehiclePosition(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<Point> pointRef) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            LOG.debug("Vehicle {} has reached point {}.", vehicleRef, pointRef);
            this.model.setVehiclePosition(vehicleRef, pointRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehiclePrecisePosition(TCSObjectReference<Vehicle> ref, Triple position) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehiclePrecisePosition(ref, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleProcState(TCSObjectReference<Vehicle> ref, Vehicle.ProcState state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            LOG.debug("Updating procState of vehicle {} to {}...", (Object)ref.getName(), (Object)state);
            this.model.setVehicleProcState(ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleRechargeOperation(TCSObjectReference<Vehicle> ref, String rechargeOperation) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleRechargeOperation(ref, rechargeOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleRouteProgressIndex(TCSObjectReference<Vehicle> ref, int index) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleRouteProgressIndex(ref, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleClaimedResources(TCSObjectReference<Vehicle> ref, List<Set<TCSResourceReference<?>>> resources) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleClaimedResources(ref, resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleAllocatedResources(TCSObjectReference<Vehicle> ref, List<Set<TCSResourceReference<?>>> resources) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleAllocatedResources(ref, resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleState(TCSObjectReference<Vehicle> ref, Vehicle.State state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleState(ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleTransportOrder(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<TransportOrder> orderRef) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleTransportOrder(vehicleRef, orderRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachCommAdapter(TCSObjectReference<Vehicle> ref, VehicleCommAdapterDescription description) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.attachmentManager.attachAdapterToVehicle(ref.getName(), this.commAdapterRegistry.findFactoryFor(description));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCommAdapter(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            VehicleEntry entry = this.vehicleEntryPool.getEntryFor(ref.getName());
            if (entry == null) {
                throw new IllegalArgumentException("No vehicle entry found for" + ref.getName());
            }
            entry.getCommAdapter().disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCommAdapter(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            VehicleEntry entry = this.vehicleEntryPool.getEntryFor(ref.getName());
            if (entry == null) {
                throw new IllegalArgumentException("No vehicle entry found for " + ref.getName());
            }
            entry.getCommAdapter().enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentInformation fetchAttachmentInformation(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.attachmentManager.getAttachmentInformation(ref.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VehicleProcessModelTO fetchProcessModel(TCSObjectReference<Vehicle> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            VehicleEntry entry = this.vehicleEntryPool.getEntryFor(ref.getName());
            if (entry == null) {
                throw new IllegalArgumentException("No vehicle entry found for " + ref.getName());
            }
            return entry.getCommAdapter().createTransferableProcessModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommAdapterCommand(TCSObjectReference<Vehicle> ref, AdapterCommand command) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.vehicleControllerPool.getVehicleController(ref.getName()).sendCommAdapterCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommAdapterMessage(TCSObjectReference<Vehicle> ref, Object message) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.vehicleControllerPool.getVehicleController(ref.getName()).sendCommAdapterMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleIntegrationLevel(TCSObjectReference<Vehicle> ref, Vehicle.IntegrationLevel integrationLevel) throws ObjectUnknownException, KernelRuntimeException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            Vehicle vehicle = this.fetchObject(Vehicle.class, ref);
            if (vehicle.isProcessingOrder() && (integrationLevel == Vehicle.IntegrationLevel.TO_BE_IGNORED || integrationLevel == Vehicle.IntegrationLevel.TO_BE_NOTICED)) {
                throw new IllegalArgumentException(String.format("%s: Cannot change integration level to %s while processing orders.", vehicle.getName(), integrationLevel.name()));
            }
            this.model.setVehicleIntegrationLevel(ref, integrationLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVehicleAllowedOrderTypes(TCSObjectReference<Vehicle> ref, Set<String> allowedOrderTypes) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.model.setVehicleAllowedOrderTypes(ref, allowedOrderTypes);
        }
    }
}

