/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.util.Assertions;
import org.opentcs.util.UniqueStringGenerator;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCSObjectPool {
    private static final Logger LOG = LoggerFactory.getLogger(TCSObjectPool.class);
    private final Map<String, TCSObject<?>> objectsByName = new ConcurrentHashMap();
    private final UniqueStringGenerator<?> objectNameGenerator = new UniqueStringGenerator();
    private final EventHandler eventHandler;

    @Inject
    public TCSObjectPool(@ApplicationEventBus EventHandler eventHandler) {
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
    }

    public void addObject(TCSObject<?> newObject) throws ObjectExistsException {
        Objects.requireNonNull(newObject, "newObject");
        if (this.objectsByName.containsKey(newObject.getName())) {
            throw new ObjectExistsException("Object name " + newObject.getName() + " already exists.");
        }
        this.objectsByName.put(newObject.getName(), newObject);
        this.objectNameGenerator.addString(newObject.getName());
    }

    public <E extends TCSObject<E>> E replaceObject(E object) {
        Objects.requireNonNull(object, "object");
        Assertions.checkArgument((boolean)this.objectsByName.containsKey(object.getName()), (String)"Object named '%s' does not exist", (Object[])new Object[]{object.getName()});
        this.objectsByName.put(object.getName(), object);
        return object;
    }

    @Nullable
    public TCSObject<?> getObjectOrNull(TCSObjectReference<?> ref) {
        Objects.requireNonNull(ref);
        return this.objectsByName.get(ref.getName());
    }

    @Nonnull
    public TCSObject<?> getObject(TCSObjectReference<?> ref) throws ObjectUnknownException {
        TCSObject<?> result = this.getObjectOrNull(ref);
        if (result == null) {
            throw new ObjectUnknownException(ref);
        }
        return result;
    }

    @Nullable
    public <T extends TCSObject<T>> T getObjectOrNull(Class<T> clazz, TCSObjectReference<T> ref) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(ref, "ref");
        TCSObject<?> result = this.objectsByName.get(ref.getName());
        if (clazz.isInstance(result)) {
            return (T)((TCSObject)clazz.cast(result));
        }
        return null;
    }

    @Nonnull
    public <T extends TCSObject<T>> T getObject(Class<T> clazz, TCSObjectReference<T> ref) throws ObjectUnknownException {
        T result = this.getObjectOrNull(clazz, ref);
        if (result == null) {
            throw new ObjectUnknownException(ref);
        }
        return result;
    }

    @Nullable
    public TCSObject<?> getObjectOrNull(String name) {
        Objects.requireNonNull(name, "name");
        return this.objectsByName.get(name);
    }

    @Nonnull
    public TCSObject<?> getObject(String name) throws ObjectUnknownException {
        TCSObject<?> result = this.getObjectOrNull(name);
        if (result == null) {
            throw new ObjectUnknownException(name);
        }
        return result;
    }

    @Nullable
    public <T extends TCSObject<T>> T getObjectOrNull(Class<T> clazz, String name) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(name, "name");
        TCSObject<?> result = this.objectsByName.get(name);
        if (clazz.isInstance(result)) {
            return (T)((TCSObject)clazz.cast(result));
        }
        return null;
    }

    @Nonnull
    public <T extends TCSObject<T>> T getObject(Class<T> clazz, String name) throws ObjectUnknownException {
        T result = this.getObjectOrNull(clazz, name);
        if (result == null) {
            throw new ObjectUnknownException(name);
        }
        return result;
    }

    public Set<TCSObject<?>> getObjects(Pattern regexp) {
        HashSet result = new HashSet();
        if (regexp == null) {
            result.addAll(this.objectsByName.values());
        } else {
            for (TCSObject<?> curObject : this.objectsByName.values()) {
                if (!regexp.matcher(curObject.getName()).matches()) continue;
                result.add(curObject);
            }
        }
        return result;
    }

    public <T extends TCSObject<T>> Set<T> getObjects(Class<T> clazz) {
        return this.getObjects(clazz, (Pattern)null);
    }

    public <T extends TCSObject<T>> Set<T> getObjects(Class<T> clazz, Pattern regexp) {
        Objects.requireNonNull(clazz, "clazz");
        HashSet<TCSObject> result = new HashSet<TCSObject>();
        for (TCSObject<?> curObject : this.objectsByName.values()) {
            if (!clazz.isInstance(curObject) || regexp != null && !regexp.matcher(curObject.getName()).matches()) continue;
            result.add((TCSObject)clazz.cast(curObject));
        }
        return result;
    }

    public <T extends TCSObject<T>> Set<T> getObjects(@Nonnull Class<T> clazz, @Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(predicate, "predicate");
        return this.objectsByName.values().stream().filter(obj -> clazz.isInstance(obj)).map(obj -> (TCSObject)clazz.cast(obj)).filter(predicate).collect(Collectors.toSet());
    }

    public boolean contains(String objectName) {
        Objects.requireNonNull(objectName, "objectName");
        return this.objectsByName.containsKey(objectName);
    }

    public TCSObject<?> removeObject(TCSObjectReference<?> ref) throws ObjectUnknownException {
        Objects.requireNonNull(ref, "ref");
        TCSObject<?> rmObject = this.objectsByName.remove(ref.getName());
        if (rmObject == null) {
            throw new ObjectUnknownException(ref);
        }
        this.objectNameGenerator.removeString(rmObject.getName());
        return rmObject;
    }

    public Set<TCSObject<?>> removeObjects(Set<String> objectNames) {
        Objects.requireNonNull(objectNames, "objectNames");
        HashSet result = new HashSet();
        for (String curName : objectNames) {
            TCSObject<?> removedObject = this.objectsByName.remove(curName);
            if (removedObject == null) continue;
            result.add(removedObject);
            this.objectNameGenerator.removeString(removedObject.getName());
        }
        return result;
    }

    public void setObjectProperty(TCSObjectReference<?> ref, String key, String value) throws ObjectUnknownException {
        Objects.requireNonNull(ref, "ref");
        TCSObject object = this.objectsByName.get(ref.getName());
        if (object == null) {
            throw new ObjectUnknownException("No object with name " + ref.getName());
        }
        TCSObject previousState = object;
        LOG.debug("Setting property on object named '{}': key='{}', value='{}'", new Object[]{ref.getName(), key, value});
        object = object.withProperty(key, value);
        this.objectsByName.put(object.getName(), object);
        this.emitObjectEvent(object, previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    public void appendObjectHistoryEntry(TCSObjectReference<?> ref, ObjectHistory.Entry entry) throws ObjectUnknownException {
        Objects.requireNonNull(ref, "ref");
        TCSObject object = this.objectsByName.get(ref.getName());
        if (object == null) {
            throw new ObjectUnknownException("No object with name " + ref.getName());
        }
        TCSObject previousState = object;
        LOG.debug("Appending history entry to object named '{}': {}", (Object)ref.getName(), (Object)entry);
        object = object.withHistoryEntry(entry);
        this.objectsByName.put(object.getName(), object);
        this.emitObjectEvent(object, previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    public void clearObjectProperties(TCSObjectReference<?> ref) throws ObjectUnknownException {
        Objects.requireNonNull(ref, "ref");
        TCSObject object = this.objectsByName.get(ref.getName());
        if (object == null) {
            throw new ObjectUnknownException("No object with name " + ref.getName());
        }
        TCSObject previousState = object;
        object = object.withProperties(new HashMap());
        this.objectsByName.put(object.getName(), object);
        this.emitObjectEvent(object, previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    public int size() {
        return this.objectsByName.size();
    }

    public boolean isEmpty() {
        return this.objectsByName.isEmpty();
    }

    public void emitObjectEvent(TCSObject<?> currentObjectState, TCSObject<?> previousObjectState, TCSObjectEvent.Type evtType) {
        this.eventHandler.onEvent((Object)new TCSObjectEvent(currentObjectState, previousObjectState, evtType));
    }
}

