/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.LocalKernel;
import org.opentcs.components.kernel.KernelExtension;
import org.opentcs.components.kernel.services.InternalPlantModelService;
import org.opentcs.customizations.kernel.ActiveInAllModes;
import org.opentcs.customizations.kernel.KernelExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelStarter {
    private static final Logger LOG = LoggerFactory.getLogger(KernelStarter.class);
    private final LocalKernel kernel;
    private final InternalPlantModelService plantModelService;
    private final Set<KernelExtension> extensions;
    private final ScheduledExecutorService kernelExecutor;

    @Inject
    protected KernelStarter(LocalKernel kernel, InternalPlantModelService plantModelService, @ActiveInAllModes Set<KernelExtension> extensions, @KernelExecutor ScheduledExecutorService kernelExecutor) {
        this.kernel = Objects.requireNonNull(kernel, "kernel");
        this.plantModelService = Objects.requireNonNull(plantModelService, "plantModelService");
        this.extensions = Objects.requireNonNull(extensions, "extensions");
        this.kernelExecutor = Objects.requireNonNull(kernelExecutor, "kernelExecutor");
    }

    public void startKernel() throws IOException {
        this.kernelExecutor.submit(() -> {
            for (KernelExtension extension : this.extensions) {
                this.kernel.addKernelExtension(extension);
            }
            this.kernel.initialize();
            LOG.debug("Kernel initialized.");
            this.plantModelService.loadPlantModel();
            this.kernel.setState(Kernel.State.OPERATING);
        });
    }
}

