/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel;

import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.opentcs.components.kernel.OrderSequenceCleanupApproval;
import org.opentcs.components.kernel.PeripheralJobCleanupApproval;
import org.opentcs.components.kernel.TransportOrderCleanupApproval;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.kernel.OrderPoolConfiguration;
import org.opentcs.kernel.workingset.PeripheralJobPoolManager;
import org.opentcs.kernel.workingset.TransportOrderPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderCleanerTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(OrderCleanerTask.class);
    private final Object globalSyncObject;
    private final TransportOrderPoolManager orderPoolManager;
    private final PeripheralJobPoolManager peripheralJobPoolManager;
    private final Set<TransportOrderCleanupApproval> orderCleanupApprovals;
    private final Set<OrderSequenceCleanupApproval> sequenceCleanupApprovals;
    private final Set<PeripheralJobCleanupApproval> peripheralJobCleanupApprovals;
    private final OrderPoolConfiguration configuration;

    @Inject
    public OrderCleanerTask(@GlobalSyncObject Object globalSyncObject, TransportOrderPoolManager orderPoolManager, PeripheralJobPoolManager peripheralJobPoolManager, Set<TransportOrderCleanupApproval> orderCleanupApprovals, Set<OrderSequenceCleanupApproval> sequenceCleanupApprovals, Set<PeripheralJobCleanupApproval> peripheralJobCleanupApprovals, OrderPoolConfiguration configuration) {
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.orderPoolManager = Objects.requireNonNull(orderPoolManager, "orderPoolManager");
        this.peripheralJobPoolManager = Objects.requireNonNull(peripheralJobPoolManager, "peripheralJobPoolManager");
        this.orderCleanupApprovals = Objects.requireNonNull(orderCleanupApprovals, "orderCleanupApprovals");
        this.sequenceCleanupApprovals = Objects.requireNonNull(sequenceCleanupApprovals, "sequenceCleanupApprovals");
        this.peripheralJobCleanupApprovals = Objects.requireNonNull(peripheralJobCleanupApprovals, "peripheralJobCleanupApprovals");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public long getSweepInterval() {
        return this.configuration.sweepInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.globalSyncObject;
        synchronized (object) {
            LOG.debug("Sweeping order pool...");
            Instant creationTimeThreshold = Instant.now().minusMillis(this.configuration.sweepAge());
            for (PeripheralJob peripheralJob : this.peripheralJobPoolManager.getObjectRepo().getObjects(PeripheralJob.class, new PeripheralJobApproval(creationTimeThreshold))) {
                this.peripheralJobPoolManager.removePeripheralJob((TCSObjectReference<PeripheralJob>)peripheralJob.getReference());
            }
            for (TransportOrder transportOrder : this.orderPoolManager.getObjectRepo().getObjects(TransportOrder.class, new OrderApproval(creationTimeThreshold))) {
                this.removeTransportOrderAndRelatedPeripheralJobs((TCSObjectReference<TransportOrder>)transportOrder.getReference());
            }
            for (OrderSequence orderSequence : this.orderPoolManager.getObjectRepo().getObjects(OrderSequence.class, new SequenceApproval(creationTimeThreshold))) {
                for (TCSObjectReference transportOrderRef : orderSequence.getOrders()) {
                    this.removeTransportOrderAndRelatedPeripheralJobs((TCSObjectReference<TransportOrder>)transportOrderRef);
                }
                this.orderPoolManager.removeFinishedOrderSequenceAndOrders((TCSObjectReference<OrderSequence>)orderSequence.getReference());
            }
        }
    }

    private void removeTransportOrderAndRelatedPeripheralJobs(TCSObjectReference<TransportOrder> transportOrderRef) {
        for (PeripheralJob peripheralJob : this.peripheralJobPoolManager.getObjectRepo().getObjects(PeripheralJob.class, job -> Objects.equals(job.getRelatedTransportOrder(), transportOrderRef))) {
            this.peripheralJobPoolManager.removePeripheralJob((TCSObjectReference<PeripheralJob>)peripheralJob.getReference());
        }
        this.orderPoolManager.removeTransportOrder(transportOrderRef);
    }

    private class PeripheralJobApproval
    implements Predicate<PeripheralJob> {
        private final Instant creationTimeThreshold;

        PeripheralJobApproval(Instant creationTimeThreshold) {
            this.creationTimeThreshold = creationTimeThreshold;
        }

        @Override
        public boolean test(PeripheralJob job) {
            if (!job.getState().isFinalState()) {
                return false;
            }
            if (job.getRelatedTransportOrder() != null) {
                return false;
            }
            if (job.getCreationTime().isAfter(this.creationTimeThreshold)) {
                return false;
            }
            for (PeripheralJobCleanupApproval approval : OrderCleanerTask.this.peripheralJobCleanupApprovals) {
                if (approval.test((Object)job)) continue;
                return false;
            }
            return true;
        }
    }

    private class OrderApproval
    implements Predicate<TransportOrder> {
        private final Instant creationTimeThreshold;

        OrderApproval(Instant creationTimeThreshold) {
            this.creationTimeThreshold = creationTimeThreshold;
        }

        @Override
        public boolean test(TransportOrder order) {
            if (!order.getState().isFinalState()) {
                return false;
            }
            if (order.getWrappingSequence() != null) {
                return false;
            }
            if (this.isRelatedToJobWithNonFinalState(order)) {
                return false;
            }
            if (order.getCreationTime().isAfter(this.creationTimeThreshold)) {
                return false;
            }
            for (TransportOrderCleanupApproval approval : OrderCleanerTask.this.orderCleanupApprovals) {
                if (approval.test((Object)order)) continue;
                return false;
            }
            return true;
        }

        private boolean isRelatedToJobWithNonFinalState(TransportOrder order) {
            return !OrderCleanerTask.this.peripheralJobPoolManager.getObjectRepo().getObjects(PeripheralJob.class, job -> Objects.equals(job.getRelatedTransportOrder(), order.getReference()) && !job.getState().isFinalState()).isEmpty();
        }
    }

    private class SequenceApproval
    implements Predicate<OrderSequence> {
        private final Instant creationTimeThreshold;

        SequenceApproval(Instant creationTimeThreshold) {
            this.creationTimeThreshold = creationTimeThreshold;
        }

        @Override
        public boolean test(OrderSequence seq) {
            TransportOrder lastOrder;
            if (!seq.isFinished()) {
                return false;
            }
            List orderRefs = seq.getOrders();
            if (!orderRefs.isEmpty() && (lastOrder = OrderCleanerTask.this.orderPoolManager.getObjectRepo().getObject(TransportOrder.class, (TCSObjectReference)Iterables.getLast((Iterable)orderRefs))).getCreationTime().isAfter(this.creationTimeThreshold)) {
                return false;
            }
            for (OrderSequenceCleanupApproval approval : OrderCleanerTask.this.sequenceCleanupApprovals) {
                if (approval.test((Object)seq)) continue;
                return false;
            }
            return true;
        }
    }
}

