/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.extensions.controlcenter.vehicles;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.VehicleCommAdapterFactory;
import org.opentcs.drivers.vehicle.management.AttachmentEvent;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.ProcessModelEvent;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.kernel.KernelApplicationConfiguration;
import org.opentcs.kernel.extensions.controlcenter.vehicles.NullVehicleCommAdapterDescription;
import org.opentcs.kernel.extensions.controlcenter.vehicles.VehicleEntry;
import org.opentcs.kernel.extensions.controlcenter.vehicles.VehicleEntryPool;
import org.opentcs.kernel.vehicles.LocalVehicleControllerPool;
import org.opentcs.kernel.vehicles.VehicleCommAdapterRegistry;
import org.opentcs.util.Assertions;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentManager
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentManager.class);
    private final KernelApplicationConfiguration configuration;
    private final TCSObjectService objectService;
    private final LocalVehicleControllerPool controllerPool;
    private final VehicleCommAdapterRegistry commAdapterRegistry;
    private final VehicleEntryPool vehicleEntryPool;
    private final EventHandler eventHandler;
    private final Map<String, AttachmentInformation> attachmentPool = new HashMap<String, AttachmentInformation>();
    private boolean initialized;

    @Inject
    public AttachmentManager(@Nonnull TCSObjectService objectService, @Nonnull LocalVehicleControllerPool controllerPool, @Nonnull VehicleCommAdapterRegistry commAdapterRegistry, @Nonnull VehicleEntryPool vehicleEntryPool, @Nonnull @ApplicationEventBus EventHandler eventHandler, @Nonnull KernelApplicationConfiguration configuration) {
        this.objectService = Objects.requireNonNull(objectService, "objectService");
        this.controllerPool = Objects.requireNonNull(controllerPool, "controllerPool");
        this.commAdapterRegistry = Objects.requireNonNull(commAdapterRegistry, "commAdapterRegistry");
        this.vehicleEntryPool = Objects.requireNonNull(vehicleEntryPool, "vehicleEntryPool");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public void initialize() {
        if (this.isInitialized()) {
            LOG.debug("Already initialized.");
            return;
        }
        this.commAdapterRegistry.initialize();
        this.vehicleEntryPool.initialize();
        this.initAttachmentPool();
        this.autoAttachAllAdapters();
        if (this.configuration.autoEnableDriversOnStartup()) {
            this.autoEnableAllAdapters();
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            LOG.debug("Not initialized.");
            return;
        }
        this.detachAllAdapters();
        this.vehicleEntryPool.terminate();
        this.commAdapterRegistry.terminate();
        this.initialized = false;
    }

    public void attachAdapterToVehicle(@Nonnull String vehicleName, @Nonnull VehicleCommAdapterFactory factory) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        Objects.requireNonNull(factory, "factory");
        LOG.info("Attaching vehicle comm adapter: '{}' -- '{}'...", (Object)vehicleName, (Object)factory.getClass().getName());
        VehicleEntry vehicleEntry = this.vehicleEntryPool.getEntryFor(vehicleName);
        if (vehicleEntry == null) {
            LOG.warn("No vehicle entry found for '{}'. Entries: {}", (Object)vehicleName, (Object)this.vehicleEntryPool);
            return;
        }
        VehicleCommAdapter commAdapter = factory.getAdapterFor(vehicleEntry.getVehicle());
        if (commAdapter == null) {
            LOG.warn("Factory {} did not provide adapter for vehicle {}, ignoring.", (Object)factory, (Object)vehicleEntry.getVehicle().getName());
            return;
        }
        this.disableAndTerminateAdapter(vehicleEntry);
        this.controllerPool.detachVehicleController(vehicleEntry.getVehicle().getName());
        commAdapter.initialize();
        this.controllerPool.attachVehicleController(vehicleEntry.getVehicle().getName(), commAdapter);
        vehicleEntry.setCommAdapterFactory(factory);
        vehicleEntry.setCommAdapter(commAdapter);
        vehicleEntry.setProcessModel(commAdapter.getProcessModel());
        this.objectService.updateObjectProperty(vehicleEntry.getVehicle().getReference(), "tcs:preferredAdapterClass", factory.getClass().getName());
        this.updateAttachmentInformation(vehicleEntry);
    }

    public void autoAttachAdapterToVehicle(@Nonnull String vehicleName) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        VehicleEntry vehicleEntry = this.vehicleEntryPool.getEntryFor(vehicleName);
        if (vehicleEntry == null) {
            LOG.warn("No vehicle entry found for '{}'. Entries: {}", (Object)vehicleName, (Object)this.vehicleEntryPool);
            return;
        }
        if (vehicleEntry.getCommAdapter() != null) {
            return;
        }
        Vehicle vehicle = this.getUpdatedVehicle(vehicleEntry.getVehicle());
        String prefAdapter = (String)vehicle.getProperties().get("tcs:preferredAdapterClass");
        VehicleCommAdapterFactory factory = this.findFactoryWithName(prefAdapter);
        if (factory != null && factory.providesAdapterFor(vehicle)) {
            this.attachAdapterToVehicle(vehicleName, factory);
        } else {
            List<VehicleCommAdapterFactory> factories;
            if (!Strings.isNullOrEmpty((String)prefAdapter)) {
                LOG.warn("Couldn't attach preferred adapter {} to {}.  Attaching first available adapter.", (Object)prefAdapter, (Object)vehicleEntry.getVehicle().getName());
            }
            if (!(factories = this.commAdapterRegistry.findFactoriesFor(vehicleEntry.getVehicle())).isEmpty()) {
                this.attachAdapterToVehicle(vehicleName, factories.get(0));
            }
        }
    }

    public void autoAttachAllAdapters() {
        this.vehicleEntryPool.getEntries().forEach((vehicleName, entry) -> this.autoAttachAdapterToVehicle((String)vehicleName));
    }

    public AttachmentInformation getAttachmentInformation(String vehicleName) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        Assertions.checkArgument((this.attachmentPool.get(vehicleName) != null ? 1 : 0) != 0, (String)"No attachment information for vehicle %s", (Object[])new Object[]{vehicleName});
        return this.attachmentPool.get(vehicleName);
    }

    public Map<String, AttachmentInformation> getAttachmentPool() {
        return this.attachmentPool;
    }

    private void disableAndTerminateAdapter(@Nonnull VehicleEntry vehicleEntry) {
        Objects.requireNonNull(vehicleEntry, "vehicleEntry");
        VehicleCommAdapter commAdapter = vehicleEntry.getCommAdapter();
        if (commAdapter != null) {
            commAdapter.disable();
            commAdapter.terminate();
        }
    }

    private void initAttachmentPool() {
        this.vehicleEntryPool.getEntries().forEach((vehicleName, entry) -> {
            List availableCommAdapters = this.commAdapterRegistry.getFactories().stream().filter(f -> f.providesAdapterFor(entry.getVehicle())).map(f -> f.getDescription()).collect(Collectors.toList());
            this.attachmentPool.put((String)vehicleName, new AttachmentInformation(entry.getVehicle().getReference(), availableCommAdapters, (VehicleCommAdapterDescription)new NullVehicleCommAdapterDescription()));
        });
    }

    private void updateAttachmentInformation(VehicleEntry entry) {
        String vehicleName = entry.getVehicleName();
        VehicleCommAdapterFactory factory = entry.getCommAdapterFactory();
        AttachmentInformation newAttachment = this.attachmentPool.get(vehicleName).withAttachedCommAdapter(factory.getDescription());
        this.attachmentPool.put(vehicleName, newAttachment);
        this.eventHandler.onEvent((Object)new AttachmentEvent(vehicleName, newAttachment));
        if (entry.getCommAdapter() == null) {
            this.eventHandler.onEvent((Object)new ProcessModelEvent(vehicleName, new VehicleProcessModelTO()));
        } else {
            this.eventHandler.onEvent((Object)new ProcessModelEvent(vehicleName, entry.getCommAdapter().createTransferableProcessModel()));
        }
    }

    private Vehicle getUpdatedVehicle(@Nonnull Vehicle vehicle) {
        Objects.requireNonNull(vehicle, "vehicle");
        return this.objectService.fetchObjects(Vehicle.class).stream().filter(updatedVehicle -> Objects.equals(updatedVehicle.getName(), vehicle.getName())).findFirst().orElse(vehicle);
    }

    private void autoEnableAllAdapters() {
        this.vehicleEntryPool.getEntries().values().stream().map(entry -> entry.getCommAdapter()).filter(adapter -> adapter != null).filter(adapter -> !adapter.isEnabled()).forEach(adapter -> adapter.enable());
    }

    private void detachAllAdapters() {
        LOG.debug("Detaching vehicle communication adapters...");
        this.vehicleEntryPool.getEntries().forEach((vehicleName, entry) -> this.disableAndTerminateAdapter((VehicleEntry)entry));
        LOG.debug("Detached vehicle communication adapters");
    }

    @Nullable
    private VehicleCommAdapterFactory findFactoryWithName(@Nullable String name) {
        return this.commAdapterRegistry.getFactories().stream().filter(factory -> factory.getClass().getName().equals(name)).findFirst().orElse(null);
    }
}

