/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.peripherals;

import com.google.inject.assistedinject.Assisted;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.components.kernel.services.InternalPeripheralService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.drivers.peripherals.PeripheralAdapterCommand;
import org.opentcs.drivers.peripherals.PeripheralCommAdapter;
import org.opentcs.drivers.peripherals.PeripheralController;
import org.opentcs.drivers.peripherals.PeripheralJobCallback;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralProcessModelEvent;
import org.opentcs.util.Assertions;
import org.opentcs.util.ExplainedBoolean;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPeripheralController
implements PeripheralController,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPeripheralController.class);
    private final TCSResourceReference<Location> location;
    private final PeripheralCommAdapter commAdapter;
    private final InternalPeripheralService peripheralService;
    private final EventBus eventBus;
    private boolean initialized;

    @Inject
    public DefaultPeripheralController(@Assisted @Nonnull TCSResourceReference<Location> location, @Assisted @Nonnull PeripheralCommAdapter commAdapter, @Nonnull InternalPeripheralService peripheralService, @Nonnull @ApplicationEventBus EventBus eventBus) {
        this.location = Objects.requireNonNull(location, "location");
        this.commAdapter = Objects.requireNonNull(commAdapter, "commAdapter");
        this.peripheralService = Objects.requireNonNull(peripheralService, "peripheralService");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventBus.subscribe((EventHandler)this);
        this.updatePeripheralState(this.commAdapter.getProcessModel().getState());
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.updatePeripheralState(PeripheralInformation.State.UNKNOWN);
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (!(event instanceof PeripheralProcessModelEvent)) {
            return;
        }
        PeripheralProcessModelEvent processModelEvent = (PeripheralProcessModelEvent)event;
        if (Objects.equals(processModelEvent.getAttributeChanged(), PeripheralProcessModel.Attribute.STATE.name()) && Objects.equals(processModelEvent.getLocation(), this.location)) {
            this.updatePeripheralState(processModelEvent.getProcessModel().getState());
        }
    }

    public void process(PeripheralJob job, PeripheralJobCallback callback) throws IllegalStateException {
        Objects.requireNonNull(job, "job");
        Objects.requireNonNull(callback, "callback");
        ExplainedBoolean canProcess = this.canProcess(job);
        Assertions.checkState((boolean)canProcess.getValue(), (String)"%s: Can't process job: %s", (Object[])new Object[]{this.location.getName(), canProcess.getReason()});
        LOG.debug("{}: Handing job to comm adapter: {}", (Object)this.location.getName(), (Object)job);
        this.commAdapter.process(job, callback);
    }

    public void abortJob() {
        this.commAdapter.abortJob();
    }

    public ExplainedBoolean canProcess(PeripheralJob job) {
        Objects.requireNonNull(job, "job");
        return this.commAdapter.canProcess(job);
    }

    public void sendCommAdapterCommand(PeripheralAdapterCommand command) {
        Objects.requireNonNull(command, "command");
        this.commAdapter.execute(command);
    }

    private void updatePeripheralState(PeripheralInformation.State newState) {
        Objects.requireNonNull(newState, "newState");
        this.peripheralService.updatePeripheralState(this.location, newState);
    }
}

