/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.peripherals;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernel.services.InternalPeripheralService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralCommAdapter;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterFactory;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentEvent;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentInformation;
import org.opentcs.drivers.peripherals.management.PeripheralProcessModelEvent;
import org.opentcs.kernel.KernelApplicationConfiguration;
import org.opentcs.kernel.peripherals.LocalPeripheralControllerPool;
import org.opentcs.kernel.peripherals.NullPeripheralCommAdapter;
import org.opentcs.kernel.peripherals.PeripheralCommAdapterRegistry;
import org.opentcs.kernel.peripherals.PeripheralEntry;
import org.opentcs.kernel.peripherals.PeripheralEntryPool;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralAttachmentManager
implements Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralAttachmentManager.class);
    private final KernelApplicationConfiguration configuration;
    private final InternalPeripheralService peripheralService;
    private final LocalPeripheralControllerPool controllerPool;
    private final PeripheralCommAdapterRegistry commAdapterRegistry;
    private final PeripheralEntryPool peripheralEntryPool;
    private final EventHandler eventHandler;
    private boolean initialized;

    @Inject
    public PeripheralAttachmentManager(@Nonnull InternalPeripheralService peripheralService, @Nonnull LocalPeripheralControllerPool controllerPool, @Nonnull PeripheralCommAdapterRegistry commAdapterRegistry, @Nonnull PeripheralEntryPool peripheralEntryPool, @Nonnull @ApplicationEventBus EventHandler eventHandler, @Nonnull KernelApplicationConfiguration configuration) {
        this.peripheralService = Objects.requireNonNull(peripheralService, "peripheralService");
        this.controllerPool = Objects.requireNonNull(controllerPool, "controllerPool");
        this.commAdapterRegistry = Objects.requireNonNull(commAdapterRegistry, "commAdapterRegistry");
        this.peripheralEntryPool = Objects.requireNonNull(peripheralEntryPool, "peripheralEntryPool");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.commAdapterRegistry.initialize();
        this.peripheralEntryPool.initialize();
        this.autoAttachAllAdapters();
        LOG.debug("Locations attached: {}", this.peripheralEntryPool.getEntries());
        if (this.configuration.autoEnablePeripheralDriversOnStartup()) {
            this.autoEnableAllAdapters();
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            LOG.debug("Not initialized.");
            return;
        }
        this.disableAndTerminateAllAdapters();
        this.peripheralEntryPool.terminate();
        this.commAdapterRegistry.terminate();
        this.initialized = false;
    }

    public void attachAdapterToLocation(@Nonnull TCSResourceReference<Location> location, @Nonnull PeripheralCommAdapterDescription description) {
        Objects.requireNonNull(location, "location");
        Objects.requireNonNull(description, "description");
        this.attachAdapterToLocation(this.peripheralEntryPool.getEntryFor(location), this.commAdapterRegistry.findFactoryFor(description));
    }

    @Nonnull
    public PeripheralAttachmentInformation getAttachmentInformation(@Nonnull TCSResourceReference<Location> location) {
        Objects.requireNonNull(location, "location");
        PeripheralEntry entry = this.peripheralEntryPool.getEntryFor(location);
        return new PeripheralAttachmentInformation(entry.getLocation(), entry.getAvailableCommAdapters(), entry.getCommAdapterFactory().getDescription());
    }

    private void attachAdapterToLocation(PeripheralEntry entry, PeripheralCommAdapterFactory factory) {
        Objects.requireNonNull(entry, "entry");
        Objects.requireNonNull(factory, "factory");
        LOG.info("Attaching peripheral comm adapter: '{}' -- '{}'...", (Object)entry.getLocation().getName(), (Object)factory.getClass().getName());
        Location location = (Location)this.peripheralService.fetchObject(Location.class, entry.getLocation());
        PeripheralCommAdapter commAdapter = factory.getAdapterFor(location);
        if (commAdapter == null) {
            LOG.warn("Factory {} did not provide adapter for location {}, ignoring.", (Object)factory, (Object)entry.getLocation().getName());
            return;
        }
        this.disableAndTerminateAdapter(entry);
        this.controllerPool.detachPeripheralController(entry.getLocation());
        commAdapter.initialize();
        this.controllerPool.attachPeripheralController(entry.getLocation(), commAdapter);
        entry.setCommAdapterFactory(factory);
        entry.setCommAdapter(commAdapter);
        this.eventHandler.onEvent((Object)new PeripheralAttachmentEvent(entry.getLocation(), new PeripheralAttachmentInformation(entry.getLocation(), entry.getAvailableCommAdapters(), entry.getCommAdapterFactory().getDescription())));
        this.eventHandler.onEvent((Object)new PeripheralProcessModelEvent(entry.getLocation(), PeripheralProcessModel.Attribute.LOCATION.name(), entry.getProcessModel()));
    }

    private void autoAttachAdapterToLocation(PeripheralEntry peripheralEntry) {
        if (!(peripheralEntry.getCommAdapter() instanceof NullPeripheralCommAdapter)) {
            return;
        }
        Location location = (Location)this.peripheralService.fetchObject(Location.class, peripheralEntry.getLocation());
        List<PeripheralCommAdapterFactory> factories = this.commAdapterRegistry.findFactoriesFor(location);
        if (!factories.isEmpty()) {
            LOG.debug("Attaching {} to first available adapter: {}.", (Object)peripheralEntry.getLocation().getName(), (Object)factories.get(0).getDescription().getDescription());
            this.attachAdapterToLocation(peripheralEntry, factories.get(0));
        }
    }

    private void autoAttachAllAdapters() {
        this.peripheralEntryPool.getEntries().forEach((location, entry) -> this.autoAttachAdapterToLocation((PeripheralEntry)entry));
    }

    private void disableAndTerminateAdapter(PeripheralEntry peripheralEntry) {
        peripheralEntry.getCommAdapter().disable();
        peripheralEntry.getCommAdapter().terminate();
    }

    private void autoEnableAllAdapters() {
        this.peripheralEntryPool.getEntries().values().stream().map(entry -> entry.getCommAdapter()).filter(adapter -> !adapter.isEnabled()).forEach(adapter -> adapter.enable());
    }

    private void disableAndTerminateAllAdapters() {
        LOG.debug("Detaching peripheral communication adapters...");
        this.peripheralEntryPool.getEntries().forEach((location, entry) -> this.disableAndTerminateAdapter((PeripheralEntry)entry));
        LOG.debug("Detached peripheral communication adapters");
    }
}

