/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.services;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.to.order.OrderSequenceCreationTO;
import org.opentcs.access.to.order.TransportOrderCreationTO;
import org.opentcs.components.kernel.services.InternalTransportOrderService;
import org.opentcs.components.kernel.services.TCSObjectService;
import org.opentcs.customizations.kernel.GlobalSyncObject;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.kernel.services.AbstractTCSObjectService;
import org.opentcs.kernel.workingset.PlantModelManager;
import org.opentcs.kernel.workingset.TCSObjectRepository;
import org.opentcs.kernel.workingset.TransportOrderPoolManager;

public class StandardTransportOrderService
extends AbstractTCSObjectService
implements InternalTransportOrderService {
    private final Object globalSyncObject;
    private final TCSObjectRepository globalObjectPool;
    private final TransportOrderPoolManager orderPoolManager;
    private final PlantModelManager plantModelManager;

    @Inject
    public StandardTransportOrderService(TCSObjectService objectService, @GlobalSyncObject Object globalSyncObject, TCSObjectRepository globalObjectPool, TransportOrderPoolManager orderPoolManager, PlantModelManager plantModelManager) {
        super(objectService);
        this.globalSyncObject = Objects.requireNonNull(globalSyncObject, "globalSyncObject");
        this.globalObjectPool = Objects.requireNonNull(globalObjectPool, "globalObjectPool");
        this.orderPoolManager = Objects.requireNonNull(orderPoolManager, "orderPoolManager");
        this.plantModelManager = Objects.requireNonNull(plantModelManager, "plantModelManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOrderSequenceFinished(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            OrderSequence seq = this.globalObjectPool.getObject(OrderSequence.class, ref);
            if (seq.isFinished()) {
                return;
            }
            this.orderPoolManager.setOrderSequenceFinished(ref);
            if (seq.getProcessingVehicle() != null) {
                Vehicle vehicle = this.globalObjectPool.getObject(Vehicle.class, seq.getProcessingVehicle());
                this.plantModelManager.setVehicleOrderSequence((TCSObjectReference<Vehicle>)vehicle.getReference(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrderSequenceFinishedIndex(TCSObjectReference<OrderSequence> ref, int index) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.orderPoolManager.setOrderSequenceFinishedIndex(ref, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrderSequenceProcessingVehicle(TCSObjectReference<OrderSequence> seqRef, TCSObjectReference<Vehicle> vehicleRef) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.orderPoolManager.setOrderSequenceProcessingVehicle(seqRef, vehicleRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransportOrderProcessingVehicle(TCSObjectReference<TransportOrder> orderRef, TCSObjectReference<Vehicle> vehicleRef, List<DriveOrder> driveOrders) throws ObjectUnknownException, IllegalArgumentException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.orderPoolManager.setTransportOrderProcessingVehicle(orderRef, vehicleRef, driveOrders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransportOrderDriveOrders(TCSObjectReference<TransportOrder> ref, List<DriveOrder> driveOrders) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.orderPoolManager.setTransportOrderDriveOrders(ref, driveOrders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransportOrderNextDriveOrder(TCSObjectReference<TransportOrder> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.orderPoolManager.setTransportOrderNextDriveOrder(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransportOrderState(TCSObjectReference<TransportOrder> ref, TransportOrder.State state) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            this.orderPoolManager.setTransportOrderState(ref, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderSequence createOrderSequence(OrderSequenceCreationTO to) {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.orderPoolManager.createOrderSequence(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportOrder createTransportOrder(TransportOrderCreationTO to) throws ObjectUnknownException, ObjectExistsException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            return this.orderPoolManager.createTransportOrder(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOrderSequenceComplete(TCSObjectReference<OrderSequence> ref) throws ObjectUnknownException {
        Object object = this.globalSyncObject;
        synchronized (object) {
            OrderSequence seq = this.globalObjectPool.getObject(OrderSequence.class, ref);
            if (seq.isComplete()) {
                return;
            }
            this.orderPoolManager.setOrderSequenceComplete(ref);
            if (seq.getNextUnfinishedOrder() == null) {
                this.orderPoolManager.setOrderSequenceFinished(ref);
                if (seq.getProcessingVehicle() != null) {
                    Vehicle vehicle = this.globalObjectPool.getObject(Vehicle.class, seq.getProcessingVehicle());
                    this.plantModelManager.setVehicleOrderSequence((TCSObjectReference<Vehicle>)vehicle.getReference(), null);
                }
            }
        }
    }
}

