/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import com.google.inject.assistedinject.Assisted;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.components.kernel.ResourceAllocationException;
import org.opentcs.components.kernel.Scheduler;
import org.opentcs.components.kernel.services.DispatcherService;
import org.opentcs.components.kernel.services.InternalVehicleService;
import org.opentcs.components.kernel.services.NotificationService;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.ReroutingType;
import org.opentcs.data.order.Route;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.MovementCommand;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleCommAdapterEvent;
import org.opentcs.drivers.vehicle.VehicleController;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.ProcessModelEvent;
import org.opentcs.kernel.vehicles.MovementCommandImpl;
import org.opentcs.kernel.vehicles.PeripheralInteractor;
import org.opentcs.kernel.vehicles.ResourceMath;
import org.opentcs.kernel.vehicles.SplitResources;
import org.opentcs.kernel.vehicles.VehicleControllerComponentsFactory;
import org.opentcs.util.Assertions;
import org.opentcs.util.ExplainedBoolean;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVehicleController
implements VehicleController,
PropertyChangeListener,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultVehicleController.class);
    private final InternalVehicleService vehicleService;
    private final NotificationService notificationService;
    private final DispatcherService dispatcherService;
    private final Scheduler scheduler;
    private final EventBus eventBus;
    private final Vehicle vehicle;
    private final VehicleCommAdapter commAdapter;
    private volatile boolean initialized;
    private final Queue<MovementCommand> futureCommands = new LinkedList<MovementCommand>();
    private volatile MovementCommand pendingCommand;
    private volatile Set<TCSResource<?>> pendingResources;
    private volatile MovementCommand interactionsPendingCommand;
    private final Queue<MovementCommand> commandsSent = new LinkedList<MovementCommand>();
    private MovementCommand lastCommandExecuted;
    private final Queue<Set<TCSResource<?>>> claimedResources = new LinkedList();
    private final Deque<Set<TCSResource<?>>> allocatedResources = new LinkedList();
    private final PeripheralInteractor peripheralInteractor;
    private volatile TransportOrder transportOrder;
    private volatile DriveOrder currentDriveOrder;
    private volatile boolean waitingForAllocation;

    @Inject
    public DefaultVehicleController(@Assisted @Nonnull Vehicle vehicle, @Assisted @Nonnull VehicleCommAdapter adapter, @Nonnull InternalVehicleService vehicleService, @Nonnull NotificationService notificationService, @Nonnull DispatcherService dispatcherService, @Nonnull Scheduler scheduler, @Nonnull @ApplicationEventBus EventBus eventBus, @Nonnull VehicleControllerComponentsFactory componentsFactory) {
        this.vehicle = Objects.requireNonNull(vehicle, "vehicle");
        this.commAdapter = Objects.requireNonNull(adapter, "adapter");
        this.vehicleService = Objects.requireNonNull(vehicleService, "vehicleService");
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
        this.dispatcherService = Objects.requireNonNull(dispatcherService, "dispatcherService");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        Objects.requireNonNull(componentsFactory, "componentsFactory");
        this.peripheralInteractor = componentsFactory.createPeripheralInteractor((TCSObjectReference<Vehicle>)vehicle.getReference());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventBus.subscribe((EventHandler)this);
        this.vehicleService.updateVehicleRechargeOperation(this.vehicle.getReference(), this.commAdapter.getRechargeOperation());
        this.commAdapter.getProcessModel().addPropertyChangeListener((PropertyChangeListener)this);
        this.setVehiclePosition(this.commAdapter.getProcessModel().getVehiclePosition());
        this.vehicleService.updateVehiclePrecisePosition(this.vehicle.getReference(), this.commAdapter.getProcessModel().getVehiclePrecisePosition());
        this.vehicleService.updateVehicleOrientationAngle(this.vehicle.getReference(), this.commAdapter.getProcessModel().getVehicleOrientationAngle());
        this.vehicleService.updateVehicleEnergyLevel(this.vehicle.getReference(), this.commAdapter.getProcessModel().getVehicleEnergyLevel());
        this.vehicleService.updateVehicleLoadHandlingDevices(this.vehicle.getReference(), this.commAdapter.getProcessModel().getVehicleLoadHandlingDevices());
        this.updateVehicleState(this.commAdapter.getProcessModel().getVehicleState());
        this.updateVehicleLength(this.commAdapter.getProcessModel().getVehicleLength());
        this.claimedResources.clear();
        this.allocatedResources.clear();
        this.peripheralInteractor.initialize();
        this.initialized = true;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.peripheralInteractor.terminate();
        this.commAdapter.getProcessModel().removePropertyChangeListener((PropertyChangeListener)this);
        this.updatePosition(null, null);
        this.vehicleService.updateVehiclePrecisePosition(this.vehicle.getReference(), null);
        this.freeAllResources();
        this.updateVehicleState(Vehicle.State.UNKNOWN);
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() != this.commAdapter.getProcessModel()) {
            return;
        }
        this.handleProcessModelEvent(evt);
    }

    public void onEvent(Object event) {
        if (!(event instanceof TCSObjectEvent)) {
            return;
        }
        TCSObjectEvent objectEvent = (TCSObjectEvent)event;
        if (objectEvent.getType() != TCSObjectEvent.Type.OBJECT_MODIFIED) {
            return;
        }
        if (!(objectEvent.getCurrentOrPreviousObjectState() instanceof Vehicle)) {
            return;
        }
        if (!Objects.equals(objectEvent.getCurrentOrPreviousObjectState().getName(), this.vehicle.getName())) {
            return;
        }
        Vehicle prevVehicleState = (Vehicle)objectEvent.getPreviousObjectState();
        Vehicle currVehicleState = (Vehicle)objectEvent.getCurrentObjectState();
        if (prevVehicleState.getIntegrationLevel() != currVehicleState.getIntegrationLevel()) {
            this.onIntegrationLevelChange(prevVehicleState, currVehicleState);
        }
    }

    public void setTransportOrder(@Nonnull TransportOrder newOrder) throws IllegalArgumentException {
        Objects.requireNonNull(newOrder, "newOrder");
        Objects.requireNonNull(newOrder.getCurrentDriveOrder(), "newOrder.getCurrentDriveOrder()");
        if (this.transportOrder == null || !Objects.equals(newOrder.getName(), this.transportOrder.getName()) || newOrder.getCurrentDriveOrderIndex() != this.transportOrder.getCurrentDriveOrderIndex()) {
            this.transportOrder = newOrder;
            this.setDriveOrder(this.transportOrder.getCurrentDriveOrder(), this.transportOrder.getProperties());
        } else {
            this.transportOrder = newOrder;
            Assertions.checkArgument((boolean)this.driveOrdersContinual(this.currentDriveOrder, this.transportOrder.getCurrentDriveOrder()), (String)"The new and old drive orders are not considered continual.");
            if (this.isForcedRerouting(this.transportOrder.getCurrentDriveOrder())) {
                Vehicle currVehicle = (Vehicle)this.vehicleService.fetchObject(Vehicle.class, this.vehicle.getReference());
                if (currVehicle.getCurrentPosition() == null) {
                    throw new IllegalArgumentException("The vehicle's current position is unknown.");
                }
                Point currPosition = (Point)this.vehicleService.fetchObject(Point.class, currVehicle.getCurrentPosition());
                if (!this.mayAllocateNow(Set.of(currPosition))) {
                    throw new IllegalArgumentException("Resources for the vehicle's current position may not be allocated now.");
                }
                this.freeAllResources();
                try {
                    this.scheduler.allocateNow((Scheduler.Client)this, Set.of(currPosition));
                    this.allocatedResources.add(Set.of(currPosition));
                    this.vehicleService.updateVehicleAllocatedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.allocatedResources));
                }
                catch (ResourceAllocationException ex) {
                    throw new IllegalArgumentException("Unable to allocate resources for the vehicle's current position.", ex);
                }
            }
            this.updateDriveOrder(this.transportOrder.getCurrentDriveOrder(), this.transportOrder.getProperties());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setDriveOrder(@Nonnull DriveOrder newOrder, @Nonnull Map<String, String> orderProperties) throws IllegalArgumentException {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            Objects.requireNonNull(newOrder, "newOrder");
            Objects.requireNonNull(orderProperties, "orderProperties");
            Objects.requireNonNull(newOrder.getRoute(), "newOrder.getRoute()");
            Assertions.checkArgument((this.currentDriveOrder == null ? 1 : 0) != 0, (String)"%s still has an order! Current order: %s, new order: %s", (Object[])new Object[]{this.vehicle.getName(), this.currentDriveOrder, newOrder});
            LOG.debug("{}: Setting drive order: {}", (Object)this.vehicle.getName(), (Object)newOrder);
            this.currentDriveOrder = newOrder;
            this.lastCommandExecuted = null;
            this.vehicleService.updateVehicleRouteProgressIndex(this.vehicle.getReference(), -1);
            List<Set<TCSResource<?>>> claim = this.remainingRequiredClaim(this.transportOrder);
            this.scheduler.claim((Scheduler.Client)this, claim);
            this.claimedResources.clear();
            this.claimedResources.addAll(claim);
            this.vehicleService.updateVehicleClaimedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.claimedResources));
            this.createFutureCommands(newOrder, orderProperties);
            if (this.canSendNextCommand()) {
                this.allocateForNextCommand();
            }
            Point nextPoint = ((Route.Step)newOrder.getRoute().getSteps().get(0)).getDestinationPoint();
            this.vehicleService.updateVehicleNextPosition(this.vehicle.getReference(), (TCSObjectReference)nextPoint.getReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateDriveOrder(@Nonnull DriveOrder newOrder, @Nonnull Map<String, String> orderProperties) throws IllegalArgumentException {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            Objects.requireNonNull(newOrder, "newOrder");
            Assertions.checkArgument((this.currentDriveOrder != null ? 1 : 0) != 0, (String)"There's no drive order to be updated");
            LOG.debug("{}: Updating drive order: {}", (Object)this.vehicle.getName(), (Object)newOrder);
            this.currentDriveOrder = newOrder;
            this.discardFutureCommands();
            List<Set<TCSResource<?>>> claim = this.remainingRequiredClaim(this.transportOrder);
            this.scheduler.claim((Scheduler.Client)this, claim);
            this.claimedResources.clear();
            this.claimedResources.addAll(claim);
            this.vehicleService.updateVehicleClaimedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.claimedResources));
            this.createFutureCommands(newOrder, orderProperties);
            this.discardSentFutureCommands();
            Vehicle updatedVehicle = (Vehicle)this.vehicleService.fetchObject(Vehicle.class, this.vehicle.getReference());
            this.vehicleService.updateVehicleRouteProgressIndex(this.vehicle.getReference(), updatedVehicle.getRouteProgressIndex());
            if (updatedVehicle.getState() == Vehicle.State.IDLE && this.canSendNextCommand()) {
                this.allocateForNextCommand();
            }
        }
    }

    private boolean driveOrdersContinual(DriveOrder oldOrder, DriveOrder newOrder) {
        LOG.debug("Checking drive order continuity for {} (old) and {} (new).", (Object)oldOrder, (Object)newOrder);
        int lastCommandExecutedRouteIndex = this.getLastCommandExecutedRouteIndex();
        if (lastCommandExecutedRouteIndex == -1) {
            LOG.debug("No route progress, yet. Considering drive orders continuous.");
            return true;
        }
        List oldSteps = oldOrder.getRoute().getSteps();
        List newSteps = newOrder.getRoute().getSteps();
        List oldProcessedSteps = oldSteps.subList(0, lastCommandExecutedRouteIndex + 1);
        List newProcessedSteps = newSteps.subList(0, lastCommandExecutedRouteIndex + 1);
        LOG.debug("Comparing steps up to the last executed command for equality: {} and {}", oldProcessedSteps, newProcessedSteps);
        if (!Objects.equals(oldProcessedSteps, newProcessedSteps)) {
            LOG.debug("Steps are not equal. Not considering drive orders continuous.");
            return false;
        }
        if (this.isForcedRerouting(newOrder)) {
            LOG.debug("New order with forced rerouting. Considering drive orders continuous.");
            return true;
        }
        int futureOrCurrentPositionIndex = this.getFutureOrCurrentPositionIndex();
        List oldPendingSteps = oldSteps.subList(lastCommandExecutedRouteIndex + 1, futureOrCurrentPositionIndex + 1);
        List newPendingSteps = newSteps.subList(lastCommandExecutedRouteIndex + 1, futureOrCurrentPositionIndex + 1);
        LOG.debug("Comparing pending steps for equality: {} and {} ", oldPendingSteps, oldPendingSteps);
        if (!Objects.equals(oldPendingSteps, newPendingSteps)) {
            LOG.debug("Steps are not equal. Not considering drive orders continuous.");
            return false;
        }
        return true;
    }

    private int getFutureOrCurrentPositionIndex() {
        if (this.getCommandsSent().isEmpty() && this.getInteractionsPendingCommand().isEmpty()) {
            LOG.debug("{}: No commands expected to be executed. Last executed command route index: {}", (Object)this.vehicle.getName(), (Object)this.getLastCommandExecutedRouteIndex());
            return this.getLastCommandExecutedRouteIndex();
        }
        if (this.getInteractionsPendingCommand().isPresent()) {
            LOG.debug("{}: Command with pending peripheral operations present. Route index: {}", (Object)this.vehicle.getName(), (Object)this.getInteractionsPendingCommand().get().getStep().getRouteIndex());
            return this.getInteractionsPendingCommand().get().getStep().getRouteIndex();
        }
        MovementCommand lastCommandSent = new LinkedList<MovementCommand>(this.getCommandsSent()).getLast();
        LOG.debug("{}: Using the last command sent to the communication adapter. Route index: {}", (Object)this.vehicle.getName(), (Object)lastCommandSent.getStep().getRouteIndex());
        return lastCommandSent.getStep().getRouteIndex();
    }

    private int getLastCommandExecutedRouteIndex() {
        if (this.lastCommandExecuted == null) {
            return -1;
        }
        return this.lastCommandExecuted.getStep().getRouteIndex();
    }

    private void discardFutureCommands() {
        this.futureCommands.clear();
        this.scheduler.clearPendingAllocations((Scheduler.Client)this);
        this.waitingForAllocation = false;
        this.pendingCommand = null;
    }

    private void discardSentFutureCommands() {
        MovementCommand lastCommandSent;
        if (this.commandsSent.isEmpty()) {
            if (this.lastCommandExecuted == null) {
                return;
            }
            lastCommandSent = this.lastCommandExecuted;
        } else {
            ArrayList<MovementCommand> commandsSentList = new ArrayList<MovementCommand>(this.commandsSent);
            lastCommandSent = (MovementCommand)commandsSentList.get(commandsSentList.size() - 1);
        }
        LOG.debug("Discarding future commands up to '{}' (inclusively): {}", (Object)lastCommandSent, this.futureCommands);
        for (int i = 0; i < lastCommandSent.getStep().getRouteIndex() + 1; ++i) {
            this.futureCommands.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTransportOrder(boolean immediate) {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            if (immediate) {
                this.clearDriveOrder();
                this.claimedResources.clear();
                this.scheduler.claim((Scheduler.Client)this, List.of());
            } else {
                this.abortDriveOrder();
                ArrayList newClaim = new ArrayList();
                if (this.pendingResources != null) {
                    newClaim.add(this.pendingResources);
                }
                this.claimedResources.clear();
                this.claimedResources.addAll(newClaim);
                this.scheduler.claim((Scheduler.Client)this, newClaim);
            }
            this.vehicleService.updateVehicleClaimedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.claimedResources));
            this.vehicleService.updateVehicleAllocatedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.allocatedResources));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void clearDriveOrder() {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            this.currentDriveOrder = null;
            this.waitingForAllocation = false;
            this.pendingResources = null;
            this.vehicleService.updateVehicleRouteProgressIndex(this.vehicle.getReference(), -1);
            this.clearCommandQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void abortDriveOrder() {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            if (this.currentDriveOrder == null) {
                LOG.debug("{}: No drive order to be aborted", (Object)this.vehicle.getName());
                return;
            }
            this.futureCommands.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void clearCommandQueue() {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            this.commAdapter.clearCommandQueue();
            this.commandsSent.clear();
            this.futureCommands.clear();
            this.pendingCommand = null;
            this.interactionsPendingCommand = null;
            this.peripheralInteractor.clear();
            SplitResources splitResources = this.lastCommandExecuted != null ? SplitResources.from(this.allocatedResources, this.toResourceSet(this.lastCommandExecuted.getStep())) : SplitResources.from(this.allocatedResources, this.allocatedResources.peek());
            for (Set<TCSResource<?>> resSet : splitResources.getResourcesAhead()) {
                this.scheduler.free((Scheduler.Client)this, resSet);
            }
            this.allocatedResources.clear();
            this.allocatedResources.addAll(splitResources.getResourcesPassed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ExplainedBoolean canProcess(TransportOrder order) {
        Objects.requireNonNull(order, "order");
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            return this.commAdapter.canProcess(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public ExplainedBoolean canProcess(@Nonnull List<String> operations) {
        Objects.requireNonNull(operations, "operations");
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            return this.commAdapter.canProcess(operations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVehiclePaused(boolean paused) {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            this.commAdapter.onVehiclePaused(paused);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommAdapterMessage(@Nullable Object message) {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            this.commAdapter.processMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommAdapterCommand(AdapterCommand command) {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            this.commAdapter.execute(command);
        }
    }

    public Queue<MovementCommand> getCommandsSent() {
        return new LinkedList<MovementCommand>(this.commandsSent);
    }

    public Optional<MovementCommand> getInteractionsPendingCommand() {
        return Optional.ofNullable(this.interactionsPendingCommand);
    }

    public boolean mayAllocateNow(Set<TCSResource<?>> resources) {
        return this.scheduler.mayAllocateNow((Scheduler.Client)this, resources);
    }

    @Nonnull
    public String getId() {
        return this.vehicle.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocationSuccessful(@Nonnull Set<TCSResource<?>> resources) {
        Objects.requireNonNull(resources, "resources");
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            if (!Objects.equals(resources, this.pendingResources)) {
                LOG.warn("{}: Allocated resources ({}) != pending resources ({}), refusing them", new Object[]{this.vehicle.getName(), resources, this.pendingResources});
                return false;
            }
            MovementCommand command = this.pendingCommand;
            if (command == null) {
                LOG.warn("{}: No pending command, pending resources = {}, refusing allocated resources: {}", new Object[]{this.vehicle.getName(), this.pendingResources, resources});
                this.waitingForAllocation = false;
                this.pendingResources = null;
                if (this.canSendNextCommand()) {
                    this.allocateForNextCommand();
                }
                return false;
            }
            this.pendingCommand = null;
            this.pendingResources = null;
            LOG.debug("{}: Accepting allocated resources: {}", (Object)this.vehicle.getName(), resources);
            this.allocatedResources.add(resources);
            this.claimedResources.poll();
            this.waitingForAllocation = false;
            this.vehicleService.updateVehicleClaimedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.claimedResources));
            this.vehicleService.updateVehicleAllocatedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.allocatedResources));
            this.interactionsPendingCommand = command;
            this.peripheralInteractor.prepareInteractions((TCSObjectReference<TransportOrder>)this.transportOrder.getReference(), command);
            this.peripheralInteractor.startPreMovementInteractions(command, () -> this.sendCommand(command), this::onMovementInteractionFailed);
        }
        return true;
    }

    public void allocationFailed(@Nonnull Set<TCSResource<?>> resources) {
        Objects.requireNonNull(resources, "resources");
        throw new IllegalStateException("Failed to allocate: " + resources);
    }

    public String toString() {
        return "DefaultVehicleController{vehicleName=" + this.vehicle.getName() + "}";
    }

    private void sendCommand(MovementCommand command) throws IllegalStateException {
        LOG.debug("{}: Enqueuing movement command with comm adapter: {}", (Object)this.vehicle.getName(), (Object)command);
        Assertions.checkState((boolean)this.commAdapter.enqueueCommand(command), (String)"Comm adapter did not accept command");
        this.commandsSent.add(command);
        this.interactionsPendingCommand = null;
        if (this.canSendNextCommand()) {
            this.allocateForNextCommand();
        }
    }

    private void onMovementInteractionFailed() {
        LOG.warn("{}: Movement interaction failed.", (Object)this.vehicle.getName());
    }

    private void handleProcessModelEvent(PropertyChangeEvent evt) {
        this.eventBus.onEvent((Object)new ProcessModelEvent(evt.getPropertyName(), this.commAdapter.createTransferableProcessModel()));
        if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.POSITION.name())) {
            this.updateVehiclePosition((String)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.PRECISE_POSITION.name())) {
            this.updateVehiclePrecisePosition((Triple)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.ORIENTATION_ANGLE.name())) {
            this.vehicleService.updateVehicleOrientationAngle(this.vehicle.getReference(), ((Double)evt.getNewValue()).doubleValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.ENERGY_LEVEL.name())) {
            this.vehicleService.updateVehicleEnergyLevel(this.vehicle.getReference(), ((Integer)evt.getNewValue()).intValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.LOAD_HANDLING_DEVICES.name())) {
            this.vehicleService.updateVehicleLoadHandlingDevices(this.vehicle.getReference(), (List)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.STATE.name())) {
            this.updateVehicleState((Vehicle.State)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.LENGTH.name())) {
            this.updateVehicleLength((Integer)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMMAND_EXECUTED.name())) {
            this.commandExecuted((MovementCommand)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMMAND_FAILED.name())) {
            this.dispatcherService.withdrawByVehicle(this.vehicle.getReference(), true);
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.USER_NOTIFICATION.name())) {
            this.notificationService.publishUserNotification((UserNotification)evt.getNewValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.COMM_ADAPTER_EVENT.name())) {
            this.eventBus.onEvent((Object)((VehicleCommAdapterEvent)evt.getNewValue()));
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.VEHICLE_PROPERTY.name())) {
            VehicleProcessModel.VehiclePropertyUpdate propUpdate = (VehicleProcessModel.VehiclePropertyUpdate)evt.getNewValue();
            this.vehicleService.updateObjectProperty(this.vehicle.getReference(), propUpdate.getKey(), propUpdate.getValue());
        } else if (Objects.equals(evt.getPropertyName(), VehicleProcessModel.Attribute.TRANSPORT_ORDER_PROPERTY.name())) {
            VehicleProcessModel.TransportOrderPropertyUpdate propUpdate = (VehicleProcessModel.TransportOrderPropertyUpdate)evt.getNewValue();
            if (this.currentDriveOrder != null) {
                this.vehicleService.updateObjectProperty(this.currentDriveOrder.getTransportOrder(), propUpdate.getKey(), propUpdate.getValue());
            }
        }
    }

    private void updateVehiclePrecisePosition(Triple precisePosition) throws ObjectUnknownException {
        Vehicle currVehicle = (Vehicle)this.vehicleService.fetchObject(Vehicle.class, this.vehicle.getReference());
        if (currVehicle.getIntegrationLevel() != Vehicle.IntegrationLevel.TO_BE_IGNORED) {
            this.vehicleService.updateVehiclePrecisePosition(this.vehicle.getReference(), precisePosition);
        }
    }

    private void updateVehiclePosition(String position) {
        Vehicle currVehicle = (Vehicle)this.vehicleService.fetchObject(Vehicle.class, this.vehicle.getReference());
        if (currVehicle.getIntegrationLevel() == Vehicle.IntegrationLevel.TO_BE_RESPECTED || currVehicle.getIntegrationLevel() == Vehicle.IntegrationLevel.TO_BE_UTILIZED) {
            this.setVehiclePosition(position);
        } else if (currVehicle.getIntegrationLevel() == Vehicle.IntegrationLevel.TO_BE_NOTICED) {
            Point point = (Point)this.vehicleService.fetchObject(Point.class, position);
            this.updatePosition(DefaultVehicleController.toReference(point), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVehiclePosition(String position) {
        Point point;
        if (position == null) {
            point = null;
        } else {
            point = (Point)this.vehicleService.fetchObject(Point.class, position);
            if (point == null) {
                LOG.warn("{}: At unknown position {}", (Object)this.vehicle.getName(), (Object)position);
                return;
            }
        }
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            if (this.currentDriveOrder == null) {
                LOG.debug("{}: Reported new position {} and we do not have a drive order.", (Object)this.vehicle.getName(), (Object)point);
                this.updatePositionWithoutOrder(point);
            } else if (this.commandsSent.isEmpty()) {
                LOG.debug("{}: Reported new position {} and we didn't send any commands of drive order.", (Object)this.vehicle.getName(), (Object)point);
                this.updatePosition(DefaultVehicleController.toReference(point), null);
            } else {
                this.updatePositionWithOrder(position, point);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandExecuted(MovementCommand executedCommand) {
        Objects.requireNonNull(executedCommand, "executedCommand");
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            MovementCommand expectedCommand = this.commandsSent.peek();
            if (!Objects.equals(expectedCommand, executedCommand)) {
                LOG.warn("{}: Communication adapter executed unexpected command: {} != {}", new Object[]{this.vehicle.getName(), executedCommand, expectedCommand});
            }
            this.lastCommandExecuted = this.commandsSent.remove();
            int freeableResourceSetCount = ResourceMath.freeableResourceSetCount(SplitResources.from(this.allocatedResources, this.toResourceSet(this.lastCommandExecuted.getStep())).getResourcesPassed(), this.commAdapter.getProcessModel().getVehicleLength());
            for (int i = 0; i < freeableResourceSetCount; ++i) {
                Set<TCSResource<?>> oldResources = this.allocatedResources.poll();
                LOG.debug("{}: Freeing resources: {}", (Object)this.vehicle.getName(), oldResources);
                this.scheduler.free((Scheduler.Client)this, oldResources);
            }
            this.vehicleService.updateVehicleAllocatedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.allocatedResources));
            this.peripheralInteractor.startPostMovementInteractions(executedCommand, this::checkForPendingCommands, this::onMovementInteractionFailed);
        }
    }

    private void checkForPendingCommands() {
        if (this.interactionsPendingCommand == null && this.pendingCommand == null && this.futureCommands.isEmpty()) {
            LOG.debug("{}: No more commands in current drive order", (Object)this.vehicle.getName());
            if (this.commandsSent.isEmpty() && !this.waitingForAllocation) {
                LOG.debug("{}: Current drive order processed", (Object)this.vehicle.getName());
                this.currentDriveOrder = null;
                this.vehicleService.updateVehicleRouteProgressIndex(this.vehicle.getReference(), -1);
                this.vehicleService.updateVehicleProcState(this.vehicle.getReference(), Vehicle.ProcState.AWAITING_ORDER);
            }
        } else if (this.canSendNextCommand()) {
            this.allocateForNextCommand();
        }
    }

    private void createFutureCommands(DriveOrder newOrder, Map<String, String> orderProperties) {
        String op = newOrder.getDestination().getOperation();
        Route orderRoute = newOrder.getRoute();
        Point finalDestination = orderRoute.getFinalDestinationPoint();
        Location finalDestinationLocation = (Location)this.vehicleService.fetchObject(Location.class, newOrder.getDestination().getDestination().getName());
        Map destProperties = newOrder.getDestination().getProperties();
        Iterator stepIter = orderRoute.getSteps().iterator();
        while (stepIter.hasNext()) {
            Route.Step curStep = (Route.Step)stepIter.next();
            if (!curStep.getDestinationPoint().isHaltingPosition()) continue;
            boolean isFinalMovement = !stepIter.hasNext();
            String operation = isFinalMovement ? op : "NOP";
            Location location = isFinalMovement ? finalDestinationLocation : null;
            this.futureCommands.add(new MovementCommandImpl(orderRoute, curStep, operation, location, isFinalMovement, finalDestinationLocation, finalDestination, op, DefaultVehicleController.mergeProperties(orderProperties, destProperties)));
        }
    }

    private void updateVehicleState(Vehicle.State newState) {
        Objects.requireNonNull(newState, "newState");
        this.vehicleService.updateVehicleState(this.vehicle.getReference(), newState);
    }

    private void updateVehicleLength(int newLength) {
        this.vehicleService.updateVehicleLength(this.vehicle.getReference(), newLength);
    }

    private boolean canSendNextCommand() {
        if (this.futureCommands.isEmpty()) {
            LOG.debug("{}: Cannot send, no commands to be sent.", (Object)this.vehicle.getName());
            return false;
        }
        if (!this.commAdapter.canAcceptNextCommand()) {
            LOG.debug("{}: Cannot send, comm adapter cannot accept any further commands.", (Object)this.vehicle.getName());
            return false;
        }
        if (!this.futureCommands.peek().getStep().isExecutionAllowed()) {
            LOG.debug("{}: Cannot send, movement execution is not allowed", (Object)this.vehicle.getName());
            return false;
        }
        if (this.waitingForAllocation) {
            LOG.debug("{}: Cannot send, waiting for allocation", (Object)this.vehicle.getName());
            return false;
        }
        if (this.pendingCommand != null) {
            LOG.debug("{}: Cannot send, resource allocation is pending for: {}", (Object)this.vehicle.getName(), (Object)this.pendingCommand);
            return false;
        }
        if (this.peripheralInteractor.isWaitingForMovementInteractionsToFinish()) {
            LOG.debug("{}: Cannot send, waiting for peripheral operations to be completed: {}", (Object)this.vehicle.getName(), this.peripheralInteractor.pendingRequiredInteractionsByDestination());
            return false;
        }
        return true;
    }

    private void allocateForNextCommand() {
        Assertions.checkState((this.pendingCommand == null ? 1 : 0) != 0, (String)"pendingCommand != null");
        MovementCommand moveCmd = this.futureCommands.poll();
        this.pendingResources = this.getNeededResources(moveCmd);
        LOG.debug("{}: Allocating resources: {}", (Object)this.vehicle.getName(), this.pendingResources);
        this.scheduler.allocate((Scheduler.Client)this, this.pendingResources);
        this.waitingForAllocation = true;
        this.pendingCommand = moveCmd;
    }

    private Set<TCSResource<?>> getNeededResources(MovementCommand cmd) {
        Objects.requireNonNull(cmd, "cmd");
        HashSet result = new HashSet();
        result.add((TCSResource<?>)cmd.getStep().getDestinationPoint());
        if (cmd.getStep().getPath() != null) {
            result.add((TCSResource<?>)cmd.getStep().getPath());
        }
        return result;
    }

    private void freeAllResources() {
        this.scheduler.freeAll((Scheduler.Client)this);
        this.allocatedResources.clear();
        this.vehicleService.updateVehicleAllocatedResources(this.vehicle.getReference(), List.of());
    }

    private MovementCommand findNextCommand() {
        MovementCommand nextCommand = this.commandsSent.stream().skip(1L).filter(cmd -> cmd != null).findFirst().orElse(null);
        if (nextCommand == null) {
            nextCommand = this.pendingCommand;
        }
        if (nextCommand == null) {
            this.futureCommands.stream().filter(cmd -> cmd != null).findFirst().orElse(null);
        }
        return nextCommand;
    }

    private void updatePositionWithoutOrder(Point point) {
        this.freeAllResources();
        if (point != null) {
            try {
                HashSet<Point> requiredResource = new HashSet<Point>();
                requiredResource.add(point);
                this.scheduler.allocateNow((Scheduler.Client)this, requiredResource);
                this.allocatedResources.add(requiredResource);
            }
            catch (ResourceAllocationException exc) {
                LOG.warn("{}: Could not allocate required resources immediately, ignored.", (Object)this.vehicle.getName(), (Object)exc);
            }
        }
        this.vehicleService.updateVehicleAllocatedResources(this.vehicle.getReference(), DefaultVehicleController.toListOfResourceSets(this.allocatedResources));
        this.updatePosition(DefaultVehicleController.toReference(point), null);
    }

    private void updatePositionWithOrder(String position, Point point) {
        MovementCommand moveCommand = (MovementCommand)this.commandsSent.stream().findFirst().get();
        Point dstPoint = moveCommand.getStep().getDestinationPoint();
        if (dstPoint.getName().equals(position)) {
            this.vehicleService.updateVehicleRouteProgressIndex(this.vehicle.getReference(), moveCommand.getStep().getRouteIndex());
        } else if (position == null) {
            LOG.info("{}: Resetting position for vehicle", (Object)this.vehicle.getName());
        } else {
            LOG.warn("{}: Reported position: {}, expected: {}", new Object[]{this.vehicle.getName(), position, dstPoint.getName()});
        }
        this.updatePosition(DefaultVehicleController.toReference(point), DefaultVehicleController.extractNextPosition(this.findNextCommand()));
    }

    private void updatePosition(TCSObjectReference<Point> posRef, TCSObjectReference<Point> nextPosRef) {
        this.vehicleService.updateVehiclePosition(this.vehicle.getReference(), posRef);
        this.vehicleService.updateVehicleNextPosition(this.vehicle.getReference(), nextPosRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onIntegrationLevelChange(Vehicle prevVehicleState, Vehicle currVehicleState) {
        Vehicle.IntegrationLevel prevIntegrationLevel = prevVehicleState.getIntegrationLevel();
        Vehicle.IntegrationLevel currIntegrationLevel = currVehicleState.getIntegrationLevel();
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            if (currIntegrationLevel == Vehicle.IntegrationLevel.TO_BE_IGNORED) {
                this.resetVehiclePosition();
                this.vehicleService.updateVehiclePrecisePosition(this.vehicle.getReference(), null);
            } else if (currIntegrationLevel == Vehicle.IntegrationLevel.TO_BE_NOTICED) {
                this.resetVehiclePosition();
                VehicleProcessModel processModel = this.commAdapter.getProcessModel();
                if (processModel.getVehiclePosition() != null) {
                    Point point = (Point)this.vehicleService.fetchObject(Point.class, processModel.getVehiclePosition());
                    this.vehicleService.updateVehiclePosition(this.vehicle.getReference(), (TCSObjectReference)point.getReference());
                }
                this.vehicleService.updateVehiclePrecisePosition(this.vehicle.getReference(), processModel.getVehiclePrecisePosition());
            } else if (!(currIntegrationLevel != Vehicle.IntegrationLevel.TO_BE_RESPECTED && currIntegrationLevel != Vehicle.IntegrationLevel.TO_BE_UTILIZED || prevIntegrationLevel != Vehicle.IntegrationLevel.TO_BE_IGNORED && prevIntegrationLevel != Vehicle.IntegrationLevel.TO_BE_NOTICED)) {
                this.allocateVehiclePosition();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetVehiclePosition() {
        VehicleCommAdapter vehicleCommAdapter = this.commAdapter;
        synchronized (vehicleCommAdapter) {
            Assertions.checkState((this.currentDriveOrder == null ? 1 : 0) != 0, (String)"%s: Vehicle has a drive order", (Object[])new Object[]{this.vehicle.getName()});
            Assertions.checkState((!this.waitingForAllocation ? 1 : 0) != 0, (String)"%s: Vehicle is waiting for resource allocation", (Object[])new Object[]{this.vehicle.getName()});
            this.setVehiclePosition(null);
        }
    }

    private void allocateVehiclePosition() {
        VehicleProcessModel processModel = this.commAdapter.getProcessModel();
        if (!this.alreadyAllocated(processModel.getVehiclePosition())) {
            this.setVehiclePosition(processModel.getVehiclePosition());
            this.vehicleService.updateVehiclePrecisePosition(this.vehicle.getReference(), processModel.getVehiclePrecisePosition());
        }
    }

    private boolean alreadyAllocated(String position) {
        return this.allocatedResources.stream().filter(resources -> resources != null).flatMap(resources -> resources.stream()).anyMatch(resource -> resource.getName().equals(position));
    }

    private static TCSObjectReference<Point> toReference(Point point) {
        return point == null ? null : point.getReference();
    }

    private static TCSObjectReference<Point> extractNextPosition(MovementCommand nextCommand) {
        if (nextCommand == null) {
            return null;
        }
        return nextCommand.getStep().getDestinationPoint().getReference();
    }

    private static Map<String, String> mergeProperties(Map<String, String> orderProps, Map<String, String> destProps) {
        Objects.requireNonNull(orderProps, "orderProps");
        Objects.requireNonNull(destProps, "destProps");
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(orderProps);
        result.putAll(destProps);
        return result;
    }

    private static List<Set<TCSResourceReference<?>>> toListOfResourceSets(Queue<Set<TCSResource<?>>> resources) {
        ArrayList result = new ArrayList(resources.size());
        for (Set set : resources) {
            result.add(set.stream().map(resource -> resource.getReference()).collect(Collectors.toSet()));
        }
        return result;
    }

    private List<Set<TCSResource<?>>> remainingRequiredClaim(@Nonnull TransportOrder order) {
        List remainingClaimCurrentDriveOrder = new ArrayList(order.getCurrentDriveOrder().getRoute().getSteps());
        if (!this.commandsSent.isEmpty() || this.lastCommandExecuted != null) {
            Route.Step lastCommandedStep = this.commandsSent.stream().reduce((cmd1, cmd2) -> cmd2).orElse(this.lastCommandExecuted).getStep();
            remainingClaimCurrentDriveOrder = remainingClaimCurrentDriveOrder.stream().dropWhile(step -> !Objects.equals(step, lastCommandedStep)).skip(1L).collect(Collectors.toCollection(ArrayList::new));
        }
        if (!this.commandsSent.isEmpty()) {
            boolean remainingClaimStartsWithCommandsSent;
            boolean bl = remainingClaimStartsWithCommandsSent = Collections.indexOfSubList(remainingClaimCurrentDriveOrder, this.commandsSent.stream().map(command -> command.getStep()).collect(Collectors.toList())) == 0;
            if (remainingClaimStartsWithCommandsSent) {
                remainingClaimCurrentDriveOrder.removeAll(this.commandsSent);
            } else {
                LOG.warn("{}: Claiming resources that should have already been allocated for the vehicle.", (Object)this.vehicle.getName());
            }
        }
        return Stream.concat(remainingClaimCurrentDriveOrder.stream(), order.getFutureDriveOrders().stream().flatMap(driveOrder -> driveOrder.getRoute().getSteps().stream())).filter(step -> step.getDestinationPoint().isHaltingPosition()).map(step -> this.toResourceSet((Route.Step)step)).collect(Collectors.toList());
    }

    private Set<TCSResource<?>> toResourceSet(Route.Step step) {
        return step.getPath() != null ? Set.of(step.getDestinationPoint(), step.getPath()) : Set.of(step.getDestinationPoint());
    }

    private boolean isForcedRerouting(DriveOrder newOrder) {
        int lastCommandExecutedRouteIndex = this.getLastCommandExecutedRouteIndex();
        if (lastCommandExecutedRouteIndex == -1) {
            LOG.debug("No route progress, yet. Not considering rerouting as forced.");
            return false;
        }
        Route.Step nextPendingStep = (Route.Step)newOrder.getRoute().getSteps().get(lastCommandExecutedRouteIndex + 1);
        return nextPendingStep.getReroutingType() == ReroutingType.FORCED;
    }
}

