/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.components.kernel.services.InternalVehicleService;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.VehicleCommAdapter;
import org.opentcs.drivers.vehicle.VehicleController;
import org.opentcs.kernel.vehicles.DefaultVehicleController;
import org.opentcs.kernel.vehicles.LocalVehicleControllerPool;
import org.opentcs.kernel.vehicles.NullVehicleController;
import org.opentcs.kernel.vehicles.VehicleControllerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultVehicleControllerPool
implements LocalVehicleControllerPool {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultVehicleControllerPool.class);
    private final InternalVehicleService vehicleService;
    private final VehicleControllerFactory vehicleManagerFactory;
    private final Map<String, PoolEntry> poolEntries = new HashMap<String, PoolEntry>();
    private boolean initialized;

    @Inject
    public DefaultVehicleControllerPool(InternalVehicleService vehicleService, VehicleControllerFactory vehicleManagerFactory) {
        this.vehicleService = Objects.requireNonNull(vehicleService, "vehicleService");
        this.vehicleManagerFactory = Objects.requireNonNull(vehicleManagerFactory, "vehicleManagerFactory");
    }

    public void initialize() {
        if (this.initialized) {
            LOG.debug("Already initialized, doing nothing.");
            return;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.initialized) {
            LOG.debug("Not initialized, doing nothing.");
            return;
        }
        for (PoolEntry curEntry : this.poolEntries.values()) {
            curEntry.vehicleController.terminate();
            Vehicle vehicle = (Vehicle)this.vehicleService.fetchObject(Vehicle.class, curEntry.vehicleName);
            this.vehicleService.updateVehiclePosition(vehicle.getReference(), null);
        }
        this.poolEntries.clear();
        this.initialized = false;
    }

    @Override
    public synchronized void attachVehicleController(String vehicleName, VehicleCommAdapter commAdapter) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        Objects.requireNonNull(commAdapter, "commAdapter");
        if (this.poolEntries.containsKey(vehicleName)) {
            LOG.warn("manager already attached, doing nothing");
            return;
        }
        Vehicle vehicle = (Vehicle)this.vehicleService.fetchObject(Vehicle.class, vehicleName);
        Preconditions.checkArgument((vehicle != null ? 1 : 0) != 0, (String)"No such vehicle: %s", (Object)vehicleName);
        DefaultVehicleController controller = this.vehicleManagerFactory.createVehicleController(vehicle, commAdapter);
        PoolEntry poolEntry = new PoolEntry(vehicleName, controller);
        this.poolEntries.put(vehicleName, poolEntry);
        controller.initialize();
    }

    @Override
    public synchronized void detachVehicleController(String vehicleName) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        LOG.debug("Detaching controller for vehicle {}...", (Object)vehicleName);
        PoolEntry poolEntry = this.poolEntries.remove(vehicleName);
        if (poolEntry == null) {
            LOG.debug("A vehicle named '{}' is not attached to a controller.", (Object)vehicleName);
            return;
        }
        poolEntry.vehicleController.terminate();
    }

    public VehicleController getVehicleController(String vehicleName) {
        Objects.requireNonNull(vehicleName, "vehicleName");
        PoolEntry poolEntry = this.poolEntries.get(vehicleName);
        return poolEntry == null ? new NullVehicleController(vehicleName) : poolEntry.vehicleController;
    }

    private static final class PoolEntry {
        private final String vehicleName;
        private final VehicleController vehicleController;

        private PoolEntry(String name, VehicleController controller) {
            this.vehicleName = Objects.requireNonNull(name, "name");
            this.vehicleController = Objects.requireNonNull(controller, "controller");
        }
    }
}

