/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.TCSResource;
import org.opentcs.util.Assertions;

public class ResourceMath {
    private ResourceMath() {
    }

    public static int freeableResourceSetCount(@Nonnull List<Set<TCSResource<?>>> resourcesPassed, int vehicleLength) {
        Objects.requireNonNull(resourcesPassed, "resourcesPassed");
        Assertions.checkArgument((vehicleLength > 0 ? 1 : 0) != 0, (String)"vehicleLength <= 0");
        ArrayList reversedPassedResources = new ArrayList(resourcesPassed);
        Collections.reverse(reversedPassedResources);
        int remainingRequiredLength = vehicleLength;
        int result = 0;
        for (Set set : reversedPassedResources) {
            if (remainingRequiredLength > 0) {
                remainingRequiredLength -= ResourceMath.requiredLength(set);
                continue;
            }
            ++result;
        }
        return result;
    }

    private static int requiredLength(Set<TCSResource<?>> resources) {
        return resources.stream().filter(resource -> resource instanceof Path).mapToLong(resource -> ((Path)resource).getLength()).mapToInt(length -> (int)length).sum();
    }
}

