/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.vehicles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentcs.data.model.TCSResource;

public class SplitResources {
    private final List<Set<TCSResource<?>>> resourcesPassed;
    private final List<Set<TCSResource<?>>> resourcesAhead;

    public SplitResources(@Nonnull List<Set<TCSResource<?>>> resourcesPassed, @Nonnull List<Set<TCSResource<?>>> resourcesAhead) {
        this.resourcesPassed = Objects.requireNonNull(resourcesPassed, "resourcesPassed");
        this.resourcesAhead = Objects.requireNonNull(resourcesAhead, "resourcesAhead");
    }

    public List<Set<TCSResource<?>>> getResourcesPassed() {
        return this.resourcesPassed;
    }

    public List<Set<TCSResource<?>>> getResourcesAhead() {
        return this.resourcesAhead;
    }

    public static SplitResources from(@Nonnull Iterable<Set<TCSResource<?>>> resourceSets, @Nonnull Set<TCSResource<?>> delimiter) {
        Objects.requireNonNull(resourceSets, "resourceSets");
        Objects.requireNonNull(delimiter, "delimiter");
        ArrayList resourcesPassed = new ArrayList();
        ArrayList resourcesAhead = new ArrayList();
        ArrayList resourcesToPutIn = resourcesPassed;
        for (Set<TCSResource<?>> curSet : resourceSets) {
            resourcesToPutIn.add(curSet);
            if (!Objects.equals(curSet, delimiter)) continue;
            resourcesToPutIn = resourcesAhead;
        }
        return new SplitResources(resourcesPassed, resourcesAhead);
    }
}

