/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.access.NotificationPublicationEvent;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.util.Assertions;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBuffer.class);
    private final Queue<UserNotification> notifications = new LinkedList<UserNotification>();
    private int capacity = 500;
    private final EventHandler messageEventListener;

    @Inject
    public NotificationBuffer(@ApplicationEventBus EventHandler eventListener) {
        this.messageEventListener = Objects.requireNonNull(eventListener, "eventListener");
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = Assertions.checkInRange((int)capacity, (int)1, (int)Integer.MAX_VALUE, (String)"capacity");
        this.cutBackMessages();
    }

    public void addNotification(UserNotification notification) {
        Objects.requireNonNull(notification, "notification");
        this.notifications.add(notification);
        LOG.debug("New notification added: {}", (Object)notification.getText());
        this.cutBackMessages();
        this.emitMessageEvent(notification);
    }

    public List<UserNotification> getNotifications(@Nullable Predicate<UserNotification> predicate) {
        Predicate<UserNotification> filterPredicate = predicate == null ? notification -> true : predicate;
        return this.notifications.stream().filter(filterPredicate).collect(Collectors.toCollection(ArrayList::new));
    }

    public void clear() {
        this.notifications.clear();
    }

    public void emitMessageEvent(UserNotification message) {
        this.messageEventListener.onEvent((Object)new NotificationPublicationEvent(message));
    }

    private void cutBackMessages() {
        while (this.notifications.size() > this.capacity) {
            this.notifications.remove();
        }
    }
}

