/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.access.to.peripherals.PeripheralJobCreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.components.kernel.ObjectNameProvider;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.kernel.workingset.TCSObjectManager;
import org.opentcs.kernel.workingset.TCSObjectRepository;
import org.opentcs.util.Assertions;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralJobPoolManager
extends TCSObjectManager {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralJobPoolManager.class);
    private final ObjectNameProvider objectNameProvider;

    @Inject
    public PeripheralJobPoolManager(@Nonnull TCSObjectRepository objectRepo, @Nonnull @ApplicationEventBus EventHandler eventHandler, @Nonnull ObjectNameProvider orderNameProvider) {
        super(objectRepo, eventHandler);
        this.objectNameProvider = Objects.requireNonNull(orderNameProvider, "orderNameProvider");
    }

    public void clear() {
        for (PeripheralJob job : this.getObjectRepo().getObjects(PeripheralJob.class)) {
            this.getObjectRepo().removeObject(job.getReference());
            this.emitObjectEvent(null, (TCSObject<?>)job, TCSObjectEvent.Type.OBJECT_REMOVED);
        }
    }

    public PeripheralJob createPeripheralJob(PeripheralJobCreationTO to) throws ObjectUnknownException, ObjectExistsException {
        PeripheralJob job = new PeripheralJob(this.nameFor(to), to.getReservationToken(), this.toPeripheralOperation(to.getPeripheralOperation())).withRelatedVehicle(this.toVehicleReference(to.getRelatedVehicleName())).withRelatedTransportOrder(this.toTransportOrderReference(to.getRelatedTransportOrderName())).withProperties(to.getProperties());
        LOG.info("Peripheral job is being created: {} -- {}", (Object)job.getName(), (Object)job.getPeripheralOperation());
        this.getObjectRepo().addObject((TCSObject<?>)job);
        this.emitObjectEvent((TCSObject<?>)job, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return job;
    }

    public PeripheralJob setPeripheralJobState(TCSObjectReference<PeripheralJob> ref, PeripheralJob.State newState) throws ObjectUnknownException {
        PeripheralJob previousState = this.getObjectRepo().getObject(PeripheralJob.class, ref);
        LOG.info("Peripheral job's state changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getState(), newState});
        PeripheralJob job = previousState.withState(newState);
        this.getObjectRepo().replaceObject((TCSObject<?>)job);
        this.emitObjectEvent((TCSObject<?>)job, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return job;
    }

    public PeripheralJob removePeripheralJob(TCSObjectReference<PeripheralJob> ref) throws ObjectUnknownException {
        PeripheralJob job = this.getObjectRepo().getObject(PeripheralJob.class, ref);
        Assertions.checkArgument((boolean)job.getState().isFinalState(), (String)"Peripheral job %s is not in a final state.", (Object[])new Object[]{job.getName()});
        this.getObjectRepo().removeObject(ref);
        this.emitObjectEvent(null, (TCSObject<?>)job, TCSObjectEvent.Type.OBJECT_REMOVED);
        return job;
    }

    private PeripheralOperation toPeripheralOperation(PeripheralOperationCreationTO to) throws ObjectUnknownException {
        return new PeripheralOperation(this.toLocationReference(to.getLocationName()), to.getOperation(), to.getExecutionTrigger(), to.isCompletionRequired());
    }

    private TCSResourceReference<Location> toLocationReference(String locationName) throws ObjectUnknownException {
        Location location = this.getObjectRepo().getObject(Location.class, locationName);
        return location.getReference();
    }

    private TCSObjectReference<Vehicle> toVehicleReference(String vehicleName) throws ObjectUnknownException {
        if (vehicleName == null) {
            return null;
        }
        Vehicle vehicle = this.getObjectRepo().getObject(Vehicle.class, vehicleName);
        return vehicle.getReference();
    }

    private TCSObjectReference<TransportOrder> toTransportOrderReference(String transportOrderName) throws ObjectUnknownException {
        if (transportOrderName == null) {
            return null;
        }
        TransportOrder order = this.getObjectRepo().getObject(TransportOrder.class, transportOrderName);
        return order.getReference();
    }

    @Nonnull
    private String nameFor(@Nonnull PeripheralJobCreationTO to) {
        if (to.hasIncompleteName()) {
            return (String)this.objectNameProvider.apply((Object)to);
        }
        return to.getName();
    }
}

