/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.opentcs.access.to.model.BlockCreationTO;
import org.opentcs.access.to.model.GroupCreationTO;
import org.opentcs.access.to.model.LocationCreationTO;
import org.opentcs.access.to.model.LocationTypeCreationTO;
import org.opentcs.access.to.model.ModelLayoutElementCreationTO;
import org.opentcs.access.to.model.PathCreationTO;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.access.to.model.PointCreationTO;
import org.opentcs.access.to.model.VehicleCreationTO;
import org.opentcs.access.to.model.VisualLayoutCreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.ObjectExistsException;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.model.Block;
import org.opentcs.data.model.Couple;
import org.opentcs.data.model.Group;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.LocationType;
import org.opentcs.data.model.Path;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.TCSResource;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.data.model.Triple;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.model.visualization.VisualLayout;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.data.peripherals.PeripheralOperation;
import org.opentcs.drivers.vehicle.LoadHandlingDevice;
import org.opentcs.kernel.workingset.TCSObjectManager;
import org.opentcs.kernel.workingset.TCSObjectRepository;
import org.opentcs.util.Assertions;
import org.opentcs.util.Colors;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlantModelManager
extends TCSObjectManager {
    private static final Logger LOG = LoggerFactory.getLogger(PlantModelManager.class);
    private String name = "";
    private Map<String, String> properties = new HashMap<String, String>();

    @Inject
    public PlantModelManager(@Nonnull TCSObjectRepository objectRepo, @Nonnull @ApplicationEventBus EventHandler eventHandler) {
        super(objectRepo, eventHandler);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public void clear() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(this.getObjectRepo().getObjects(VisualLayout.class));
        objects.addAll(this.getObjectRepo().getObjects(Vehicle.class));
        objects.addAll(this.getObjectRepo().getObjects(Group.class));
        objects.addAll(this.getObjectRepo().getObjects(Block.class));
        objects.addAll(this.getObjectRepo().getObjects(Path.class));
        objects.addAll(this.getObjectRepo().getObjects(Location.class));
        objects.addAll(this.getObjectRepo().getObjects(LocationType.class));
        objects.addAll(this.getObjectRepo().getObjects(Point.class));
        for (TCSObject tCSObject : objects) {
            this.getObjectRepo().removeObject(tCSObject.getReference());
            this.emitObjectEvent(null, tCSObject, TCSObjectEvent.Type.OBJECT_REMOVED);
        }
    }

    public void createPlantModelObjects(PlantModelCreationTO to) throws ObjectExistsException, ObjectUnknownException {
        LOG.info("Plant model is being created: {}", (Object)to.getName());
        this.clear();
        this.setName(to.getName());
        this.setProperties(to.getProperties());
        for (PointCreationTO point : to.getPoints()) {
            this.createPoint(point);
        }
        for (LocationTypeCreationTO locType : to.getLocationTypes()) {
            this.createLocationType(locType);
        }
        for (LocationCreationTO loc : to.getLocations()) {
            this.createLocation(loc);
        }
        for (PathCreationTO path : to.getPaths()) {
            this.createPath(path);
        }
        for (BlockCreationTO block : to.getBlocks()) {
            this.createBlock(block);
        }
        for (GroupCreationTO group : to.getGroups()) {
            this.createGroup(group);
        }
        for (VehicleCreationTO vehicle : to.getVehicles()) {
            this.createVehicle(vehicle);
        }
        this.createVisualLayout(to.getVisualLayout());
        this.overrideLayoutData(to.getVisualLayout());
    }

    public Path setPathLocked(TCSObjectReference<Path> ref, boolean newLocked) throws ObjectUnknownException {
        Path previousState = this.getObjectRepo().getObject(Path.class, ref);
        Path path = previousState.withLocked(newLocked);
        this.getObjectRepo().replaceObject((TCSObject<?>)path.withLocked(newLocked));
        this.emitObjectEvent((TCSObject<?>)path, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return path;
    }

    public Location setLocationLocked(TCSObjectReference<Location> ref, boolean newLocked) throws ObjectUnknownException {
        Location previousState = this.getObjectRepo().getObject(Location.class, ref);
        Location location = previousState.withLocked(newLocked);
        this.getObjectRepo().replaceObject((TCSObject<?>)location);
        this.emitObjectEvent((TCSObject<?>)location, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return location;
    }

    public Location setLocationReservationToken(TCSObjectReference<Location> ref, String newToken) throws ObjectUnknownException {
        Location previousState = this.getObjectRepo().getObject(Location.class, ref);
        Location location = previousState.withPeripheralInformation(previousState.getPeripheralInformation().withReservationToken(newToken));
        this.getObjectRepo().replaceObject((TCSObject<?>)location);
        this.emitObjectEvent((TCSObject<?>)location, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return location;
    }

    public Location setLocationProcState(TCSObjectReference<Location> ref, PeripheralInformation.ProcState newState) throws ObjectUnknownException {
        Location previousState = this.getObjectRepo().getObject(Location.class, ref);
        Location location = previousState.withPeripheralInformation(previousState.getPeripheralInformation().withProcState(newState));
        this.getObjectRepo().replaceObject((TCSObject<?>)location);
        this.emitObjectEvent((TCSObject<?>)location, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return location;
    }

    public Location setLocationState(TCSObjectReference<Location> ref, PeripheralInformation.State newState) throws ObjectUnknownException {
        Location previousState = this.getObjectRepo().getObject(Location.class, ref);
        Location location = previousState.withPeripheralInformation(previousState.getPeripheralInformation().withState(newState));
        this.getObjectRepo().replaceObject((TCSObject<?>)location);
        this.emitObjectEvent((TCSObject<?>)location, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return location;
    }

    public Location setLocationPeripheralJob(TCSObjectReference<Location> ref, TCSObjectReference<PeripheralJob> newJob) throws ObjectUnknownException {
        Location previousState = this.getObjectRepo().getObject(Location.class, ref);
        Location location = previousState.withPeripheralInformation(previousState.getPeripheralInformation().withPeripheralJob(newJob));
        this.getObjectRepo().replaceObject((TCSObject<?>)location);
        this.emitObjectEvent((TCSObject<?>)location, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return location;
    }

    public Vehicle setVehicleEnergyLevel(TCSObjectReference<Vehicle> ref, int energyLevel) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        Vehicle vehicle = previousState.withEnergyLevel(energyLevel);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleRechargeOperation(TCSObjectReference<Vehicle> ref, String rechargeOperation) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.info("Vehicle's recharge operation changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getRechargeOperation(), rechargeOperation});
        Vehicle vehicle = previousState.withRechargeOperation(rechargeOperation);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleLoadHandlingDevices(TCSObjectReference<Vehicle> ref, List<LoadHandlingDevice> devices) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        Vehicle vehicle = previousState.withLoadHandlingDevices(devices);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleState(TCSObjectReference<Vehicle> ref, Vehicle.State newState) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.debug("Vehicle's state changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getState(), newState});
        Vehicle vehicle = previousState.withState(newState);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleLength(TCSObjectReference<Vehicle> ref, int newLength) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.debug("Vehicle's length changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getLength(), newLength});
        Vehicle vehicle = previousState.withLength(newLength);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleIntegrationLevel(TCSObjectReference<Vehicle> ref, Vehicle.IntegrationLevel integrationLevel) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.info("Vehicle's integration level changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getIntegrationLevel(), integrationLevel});
        Vehicle vehicle = previousState.withIntegrationLevel(integrationLevel);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehiclePaused(TCSObjectReference<Vehicle> ref, boolean paused) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.info("Vehicle's paused state changes: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.isPaused(), paused});
        Vehicle vehicle = previousState.withPaused(paused);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleProcState(TCSObjectReference<Vehicle> ref, Vehicle.ProcState newState) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        Vehicle vehicle = previousState.withProcState(newState);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleAllowedOrderTypes(TCSObjectReference<Vehicle> ref, Set<String> allowedOrderTypes) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.info("Vehicle's allowed order types change: {} -- {} -> {}", new Object[]{previousState.getName(), previousState.getAllowedOrderTypes(), allowedOrderTypes});
        Vehicle vehicle = previousState.withAllowedOrderTypes(allowedOrderTypes);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehiclePosition(TCSObjectReference<Vehicle> ref, TCSObjectReference<Point> newPosRef) throws ObjectUnknownException {
        Point previousPointState;
        Vehicle vehicle = this.getObjectRepo().getObject(Vehicle.class, ref);
        LOG.debug("Vehicle's position changes: {} -- {} -> {}", new Object[]{vehicle.getName(), vehicle.getCurrentPosition() == null ? null : vehicle.getCurrentPosition().getName(), newPosRef == null ? null : newPosRef.getName()});
        Vehicle previousVehicleState = vehicle;
        if (vehicle.getCurrentPosition() != null) {
            Point oldVehiclePos;
            previousPointState = oldVehiclePos = this.getObjectRepo().getObject(Point.class, vehicle.getCurrentPosition());
            oldVehiclePos = oldVehiclePos.withOccupyingVehicle(null);
            this.getObjectRepo().replaceObject((TCSObject<?>)oldVehiclePos);
            this.emitObjectEvent((TCSObject<?>)oldVehiclePos, (TCSObject<?>)previousPointState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        }
        if (newPosRef != null) {
            Point newVehiclePos;
            previousPointState = newVehiclePos = this.getObjectRepo().getObject(Point.class, newPosRef);
            newVehiclePos = newVehiclePos.withOccupyingVehicle(ref);
            this.getObjectRepo().replaceObject((TCSObject<?>)newVehiclePos);
            this.emitObjectEvent((TCSObject<?>)newVehiclePos, (TCSObject<?>)previousPointState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        }
        vehicle = vehicle.withCurrentPosition(newPosRef);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousVehicleState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleNextPosition(TCSObjectReference<Vehicle> ref, TCSObjectReference<Point> newPosition) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        Vehicle vehicle = previousState.withNextPosition(newPosition);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehiclePrecisePosition(TCSObjectReference<Vehicle> ref, Triple newPosition) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        Vehicle vehicle = previousState.withPrecisePosition(newPosition);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleOrientationAngle(TCSObjectReference<Vehicle> ref, double angle) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, ref);
        Vehicle vehicle = previousState.withOrientationAngle(angle);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleTransportOrder(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<TransportOrder> orderRef) throws ObjectUnknownException {
        Vehicle vehicle;
        Vehicle previousState = vehicle = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
        if (orderRef == null) {
            vehicle = vehicle.withTransportOrder(null);
            this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        } else {
            TransportOrder order = this.getObjectRepo().getObject(TransportOrder.class, orderRef);
            vehicle = vehicle.withTransportOrder(order.getReference());
            this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        }
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleOrderSequence(TCSObjectReference<Vehicle> vehicleRef, TCSObjectReference<OrderSequence> seqRef) throws ObjectUnknownException {
        Vehicle vehicle;
        Vehicle previousState = vehicle = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
        if (seqRef == null) {
            vehicle = vehicle.withOrderSequence(null);
            this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        } else {
            OrderSequence seq = this.getObjectRepo().getObject(OrderSequence.class, seqRef);
            vehicle = vehicle.withOrderSequence(seq.getReference());
            this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        }
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleRouteProgressIndex(TCSObjectReference<Vehicle> vehicleRef, int index) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
        Vehicle vehicle = previousState.withRouteProgressIndex(index);
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleClaimedResources(TCSObjectReference<Vehicle> vehicleRef, List<Set<TCSResourceReference<?>>> resources) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
        Vehicle vehicle = previousState.withClaimedResources(PlantModelManager.unmodifiableCopy(resources));
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public Vehicle setVehicleAllocatedResources(TCSObjectReference<Vehicle> vehicleRef, List<Set<TCSResourceReference<?>>> resources) throws ObjectUnknownException {
        Vehicle previousState = this.getObjectRepo().getObject(Vehicle.class, vehicleRef);
        Vehicle vehicle = previousState.withAllocatedResources(PlantModelManager.unmodifiableCopy(resources));
        this.getObjectRepo().replaceObject((TCSObject<?>)vehicle);
        this.emitObjectEvent((TCSObject<?>)vehicle, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return vehicle;
    }

    public PlantModelCreationTO createPlantModelCreationTO() {
        return new PlantModelCreationTO(this.name).withProperties(this.getProperties()).withPoints(this.getPoints()).withPaths(this.getPaths()).withVehicles(this.getVehicles()).withLocationTypes(this.getLocationTypes()).withLocations(this.getLocations()).withBlocks(this.getBlocks()).withGroups(this.getGroups()).withVisualLayout(this.getVisualLayout());
    }

    public Set<TCSResource<?>> expandResources(@Nonnull Set<TCSResourceReference<?>> resources) throws ObjectUnknownException {
        Objects.requireNonNull(resources, "resources");
        Set<Block> blocks = this.getObjectRepo().getObjects(Block.class);
        HashSet refsToLookUp = new HashSet();
        for (TCSResourceReference<?> resourceRef : resources) {
            refsToLookUp.add(resourceRef);
            blocks.stream().filter(block -> block.getMembers().contains(resourceRef)).flatMap(block -> block.getMembers().stream()).forEach(memberRef -> refsToLookUp.add((TCSResourceReference<?>)memberRef));
        }
        return refsToLookUp.stream().map(memberRef -> (TCSResource)this.getObjectRepo().getObject((TCSObjectReference<?>)memberRef)).collect(Collectors.toSet());
    }

    private List<PeripheralOperation> mapPeripheralOperationTOs(List<PeripheralOperationCreationTO> creationTOs) {
        return creationTOs.stream().map(operationTO -> new PeripheralOperation(this.getObjectRepo().getObject(Location.class, operationTO.getLocationName()).getReference(), operationTO.getOperation(), operationTO.getExecutionTrigger(), operationTO.isCompletionRequired())).collect(Collectors.toList());
    }

    private List<PointCreationTO> getPoints() {
        Set<Point> points = this.getObjectRepo().getObjects(Point.class);
        ArrayList<PointCreationTO> result = new ArrayList<PointCreationTO>();
        for (Point curPoint : points) {
            result.add(new PointCreationTO(curPoint.getName()).withPosition(curPoint.getPosition()).withVehicleOrientationAngle(curPoint.getVehicleOrientationAngle()).withType(curPoint.getType()).withProperties(curPoint.getProperties()).withLayout(new PointCreationTO.Layout(curPoint.getLayout().getPosition(), curPoint.getLayout().getLabelOffset(), curPoint.getLayout().getLayerId())));
        }
        return result;
    }

    private List<PathCreationTO> getPaths() {
        Set<Path> paths = this.getObjectRepo().getObjects(Path.class);
        ArrayList<PathCreationTO> result = new ArrayList<PathCreationTO>();
        for (Path curPath : paths) {
            result.add(new PathCreationTO(curPath.getName(), curPath.getSourcePoint().getName(), curPath.getDestinationPoint().getName()).withLength(curPath.getLength()).withMaxVelocity(curPath.getMaxVelocity()).withMaxReverseVelocity(curPath.getMaxReverseVelocity()).withLocked(curPath.isLocked()).withPeripheralOperations(this.getPeripheralOperations(curPath)).withProperties(curPath.getProperties()).withLayout(new PathCreationTO.Layout(curPath.getLayout().getConnectionType(), curPath.getLayout().getControlPoints(), curPath.getLayout().getLayerId())));
        }
        return result;
    }

    private List<PeripheralOperationCreationTO> getPeripheralOperations(Path path) {
        return path.getPeripheralOperations().stream().map(op -> new PeripheralOperationCreationTO(op.getOperation(), op.getLocation().getName()).withExecutionTrigger(op.getExecutionTrigger()).withCompletionRequired(op.isCompletionRequired())).collect(Collectors.toList());
    }

    private List<VehicleCreationTO> getVehicles() {
        Set<Vehicle> vehicles = this.getObjectRepo().getObjects(Vehicle.class);
        ArrayList<VehicleCreationTO> result = new ArrayList<VehicleCreationTO>();
        for (Vehicle vehicle : vehicles) {
            result.add(new VehicleCreationTO(vehicle.getName()).withLength(vehicle.getLength()).withEnergyLevelGood(vehicle.getEnergyLevelGood()).withEnergyLevelCritical(vehicle.getEnergyLevelCritical()).withEnergyLevelFullyRecharged(vehicle.getEnergyLevelFullyRecharged()).withEnergyLevelSufficientlyRecharged(vehicle.getEnergyLevelSufficientlyRecharged()).withMaxVelocity(vehicle.getMaxVelocity()).withMaxReverseVelocity(vehicle.getMaxReverseVelocity()).withProperties(vehicle.getProperties()).withLayout(new VehicleCreationTO.Layout(vehicle.getLayout().getRouteColor())));
        }
        return result;
    }

    private List<LocationTypeCreationTO> getLocationTypes() {
        Set<LocationType> locTypes = this.getObjectRepo().getObjects(LocationType.class);
        ArrayList<LocationTypeCreationTO> result = new ArrayList<LocationTypeCreationTO>();
        for (LocationType curType : locTypes) {
            result.add(new LocationTypeCreationTO(curType.getName()).withAllowedOperations(curType.getAllowedOperations()).withAllowedPeripheralOperations(curType.getAllowedPeripheralOperations()).withProperties(curType.getProperties()).withLayout(new LocationTypeCreationTO.Layout(curType.getLayout().getLocationRepresentation())));
        }
        return result;
    }

    private List<LocationCreationTO> getLocations() {
        Set<Location> locations = this.getObjectRepo().getObjects(Location.class);
        ArrayList<LocationCreationTO> result = new ArrayList<LocationCreationTO>();
        for (Location curLoc : locations) {
            result.add(new LocationCreationTO(curLoc.getName(), curLoc.getType().getName(), curLoc.getPosition()).withLinks(curLoc.getAttachedLinks().stream().collect(Collectors.toMap(link -> link.getPoint().getName(), Location.Link::getAllowedOperations))).withLocked(curLoc.isLocked()).withProperties(curLoc.getProperties()).withLayout(new LocationCreationTO.Layout(curLoc.getLayout().getPosition(), curLoc.getLayout().getLabelOffset(), curLoc.getLayout().getLocationRepresentation(), curLoc.getLayout().getLayerId())));
        }
        return result;
    }

    private List<BlockCreationTO> getBlocks() {
        Set<Block> blocks = this.getObjectRepo().getObjects(Block.class);
        ArrayList<BlockCreationTO> result = new ArrayList<BlockCreationTO>();
        for (Block curBlock : blocks) {
            result.add(new BlockCreationTO(curBlock.getName()).withMemberNames(curBlock.getMembers().stream().map(member -> member.getName()).collect(Collectors.toSet())).withType(curBlock.getType()).withProperties(curBlock.getProperties()).withLayout(new BlockCreationTO.Layout(curBlock.getLayout().getColor())));
        }
        return result;
    }

    @Deprecated
    private List<GroupCreationTO> getGroups() {
        Set<Group> groups = this.getObjectRepo().getObjects(Group.class);
        ArrayList<GroupCreationTO> result = new ArrayList<GroupCreationTO>();
        for (Group curGroup : groups) {
            result.add(new GroupCreationTO(curGroup.getName()).withMemberNames(curGroup.getMembers().stream().map(member -> member.getName()).collect(Collectors.toSet())).withProperties(curGroup.getProperties()));
        }
        return result;
    }

    private VisualLayoutCreationTO getVisualLayout() {
        Set<VisualLayout> layouts = this.getObjectRepo().getObjects(VisualLayout.class);
        Assertions.checkState((layouts.size() == 1 ? 1 : 0) != 0, (String)"There has to be one, and only one, visual layout. Number of visual layouts: %d", (Object[])new Object[]{layouts.size()});
        VisualLayout layout = layouts.iterator().next();
        return new VisualLayoutCreationTO(layout.getName()).withScaleX(layout.getScaleX()).withScaleY(layout.getScaleY()).withProperties(layout.getProperties()).withLayers(layout.getLayers()).withLayerGroups(layout.getLayerGroups());
    }

    private VisualLayout createVisualLayout(VisualLayoutCreationTO to) throws ObjectUnknownException, ObjectExistsException {
        VisualLayout newLayout = new VisualLayout(to.getName()).withScaleX(to.getScaleX()).withScaleY(to.getScaleY()).withLayers(to.getLayers()).withLayerGroups(to.getLayerGroups());
        this.getObjectRepo().addObject((TCSObject<?>)newLayout);
        this.emitObjectEvent((TCSObject<?>)newLayout, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newLayout;
    }

    private Point createPoint(PointCreationTO to) throws ObjectExistsException {
        Point newPoint = new Point(to.getName()).withPosition(to.getPosition()).withType(to.getType()).withVehicleOrientationAngle(to.getVehicleOrientationAngle()).withProperties(to.getProperties()).withLayout(new Point.Layout(to.getLayout().getPosition(), to.getLayout().getLabelOffset(), to.getLayout().getLayerId()));
        this.getObjectRepo().addObject((TCSObject<?>)newPoint);
        this.emitObjectEvent((TCSObject<?>)newPoint, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newPoint;
    }

    private Path createPath(PathCreationTO to) throws ObjectUnknownException, ObjectExistsException {
        Objects.requireNonNull(to, "to");
        Point srcPoint = this.getObjectRepo().getObject(Point.class, to.getSrcPointName());
        Point destPoint = this.getObjectRepo().getObject(Point.class, to.getDestPointName());
        Path newPath = new Path(to.getName(), (TCSObjectReference)srcPoint.getReference(), (TCSObjectReference)destPoint.getReference()).withLength(to.getLength()).withMaxVelocity(to.getMaxVelocity()).withMaxReverseVelocity(to.getMaxReverseVelocity()).withPeripheralOperations(this.mapPeripheralOperationTOs(to.getPeripheralOperations())).withProperties(to.getProperties()).withLocked(to.isLocked()).withLayout(new Path.Layout(to.getLayout().getConnectionType(), to.getLayout().getControlPoints(), to.getLayout().getLayerId()));
        this.getObjectRepo().addObject((TCSObject<?>)newPath);
        this.emitObjectEvent((TCSObject<?>)newPath, null, TCSObjectEvent.Type.OBJECT_CREATED);
        this.addPointOutgoingPath((TCSObjectReference<Point>)srcPoint.getReference(), (TCSObjectReference<Path>)newPath.getReference());
        this.addPointIncomingPath((TCSObjectReference<Point>)destPoint.getReference(), (TCSObjectReference<Path>)newPath.getReference());
        return newPath;
    }

    private LocationType createLocationType(LocationTypeCreationTO to) throws ObjectExistsException {
        LocationType newType = new LocationType(to.getName()).withAllowedOperations(to.getAllowedOperations()).withAllowedPeripheralOperations(to.getAllowedPeripheralOperations()).withProperties(to.getProperties()).withLayout(new LocationType.Layout(to.getLayout().getLocationRepresentation()));
        this.getObjectRepo().addObject((TCSObject<?>)newType);
        this.emitObjectEvent((TCSObject<?>)newType, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newType;
    }

    private Location createLocation(LocationCreationTO to) throws ObjectUnknownException, ObjectExistsException {
        Point point;
        LocationType type = this.getObjectRepo().getObject(LocationType.class, to.getTypeName());
        Location newLocation = new Location(to.getName(), type.getReference()).withPosition(to.getPosition()).withLocked(to.isLocked()).withProperties(to.getProperties()).withLayout(new Location.Layout(to.getLayout().getPosition(), to.getLayout().getLabelOffset(), to.getLayout().getLocationRepresentation(), to.getLayout().getLayerId()));
        HashSet<Location.Link> locationLinks = new HashSet<Location.Link>();
        for (Map.Entry linkEntry : to.getLinks().entrySet()) {
            point = this.getObjectRepo().getObject(Point.class, (String)linkEntry.getKey());
            Location.Link link = new Location.Link(newLocation.getReference(), point.getReference()).withAllowedOperations((Set)linkEntry.getValue());
            locationLinks.add(link);
        }
        newLocation = newLocation.withAttachedLinks(locationLinks);
        this.getObjectRepo().addObject((TCSObject<?>)newLocation);
        this.emitObjectEvent((TCSObject<?>)newLocation, null, TCSObjectEvent.Type.OBJECT_CREATED);
        for (Location.Link link : locationLinks) {
            point = this.getObjectRepo().getObject(Point.class, link.getPoint());
            HashSet<Location.Link> pointLinks = new HashSet<Location.Link>(point.getAttachedLinks());
            pointLinks.add(link);
            Point previousPointState = point;
            point = point.withAttachedLinks(pointLinks);
            this.getObjectRepo().replaceObject((TCSObject<?>)point);
            this.emitObjectEvent((TCSObject<?>)point, (TCSObject<?>)previousPointState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        }
        return newLocation;
    }

    private Vehicle createVehicle(VehicleCreationTO to) throws ObjectExistsException {
        Vehicle newVehicle = new Vehicle(to.getName()).withLength(to.getLength()).withEnergyLevelGood(to.getEnergyLevelGood()).withEnergyLevelCritical(to.getEnergyLevelCritical()).withEnergyLevelFullyRecharged(to.getEnergyLevelFullyRecharged()).withEnergyLevelSufficientlyRecharged(to.getEnergyLevelSufficientlyRecharged()).withMaxVelocity(to.getMaxVelocity()).withMaxReverseVelocity(to.getMaxReverseVelocity()).withProperties(to.getProperties()).withLayout(new Vehicle.Layout(to.getLayout().getRouteColor()));
        this.getObjectRepo().addObject((TCSObject<?>)newVehicle);
        this.emitObjectEvent((TCSObject<?>)newVehicle, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newVehicle;
    }

    private Block createBlock(BlockCreationTO to) throws ObjectExistsException, ObjectUnknownException {
        HashSet<TCSResourceReference> members = new HashSet<TCSResourceReference>();
        for (String memberName : to.getMemberNames()) {
            TCSObject<?> object = this.getObjectRepo().getObject(memberName);
            if (!(object instanceof TCSResource)) {
                throw new ObjectUnknownException(memberName);
            }
            members.add(((TCSResource)object).getReference());
        }
        Block newBlock = new Block(to.getName()).withType(to.getType()).withMembers(members).withProperties(to.getProperties()).withLayout(new Block.Layout(to.getLayout().getColor()));
        this.getObjectRepo().addObject((TCSObject<?>)newBlock);
        this.emitObjectEvent((TCSObject<?>)newBlock, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newBlock;
    }

    @Deprecated
    private Group createGroup(GroupCreationTO to) throws ObjectExistsException, ObjectUnknownException {
        HashSet<TCSObjectReference> members = new HashSet<TCSObjectReference>();
        for (String memberName : to.getMemberNames()) {
            TCSObject<?> object = this.getObjectRepo().getObject(memberName);
            if (object == null) {
                throw new ObjectUnknownException(memberName);
            }
            members.add(object.getReference());
        }
        Group newGroup = new Group(to.getName()).withMembers(members).withProperties(to.getProperties());
        this.getObjectRepo().addObject((TCSObject<?>)newGroup);
        this.emitObjectEvent((TCSObject<?>)newGroup, null, TCSObjectEvent.Type.OBJECT_CREATED);
        return newGroup;
    }

    @Deprecated
    private void overrideLayoutData(VisualLayoutCreationTO layout) {
        for (ModelLayoutElementCreationTO mleTO : layout.getModelElements()) {
            TCSObject<?> object = this.getObjectRepo().getObject(mleTO.getName());
            Map props = mleTO.getProperties();
            if (object instanceof Point) {
                this.overridePointLayoutData((Point)object, props);
                continue;
            }
            if (object instanceof Path) {
                this.overridePathLayoutData((Path)object, props);
                continue;
            }
            if (object instanceof Location) {
                this.overrideLocationLayoutData((Location)object, props);
                continue;
            }
            if (object instanceof Block) {
                this.overrideBlockLayoutData((Block)object, props);
                continue;
            }
            if (!(object instanceof Vehicle)) continue;
            this.overrideVehicleLayoutData((TCSObject<?>)((Vehicle)object), props);
        }
    }

    private void overridePointLayoutData(Point oldPoint, Map<String, String> properties) throws NumberFormatException {
        long positionX = properties.get("POSITION_X") != null ? (long)Integer.parseInt(properties.get("POSITION_X")) : oldPoint.getLayout().getPosition().getX();
        long positionY = properties.get("POSITION_Y") != null ? (long)Integer.parseInt(properties.get("POSITION_Y")) : oldPoint.getLayout().getPosition().getY();
        long labelOffsetX = properties.get("LABEL_OFFSET_X") != null ? (long)Integer.parseInt(properties.get("LABEL_OFFSET_X")) : oldPoint.getLayout().getLabelOffset().getX();
        long labelOffsetY = properties.get("LABEL_OFFSET_Y") != null ? (long)Integer.parseInt(properties.get("LABEL_OFFSET_Y")) : oldPoint.getLayout().getLabelOffset().getY();
        Point newPoint = oldPoint.withLayout(new Point.Layout(new Couple(positionX, positionY), new Couple(labelOffsetX, labelOffsetY), oldPoint.getLayout().getLayerId()));
        this.getObjectRepo().replaceObject((TCSObject<?>)newPoint);
        this.emitObjectEvent((TCSObject<?>)newPoint, (TCSObject<?>)oldPoint, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    private void overridePathLayoutData(Path oldPath, Map<String, String> properties) throws IllegalArgumentException {
        Path.Layout.ConnectionType connectionType;
        String connectionTypeString;
        switch (connectionTypeString = properties.getOrDefault("CONN_TYPE", oldPath.getLayout().getConnectionType().name())) {
            case "DIRECT": {
                connectionType = Path.Layout.ConnectionType.DIRECT;
                break;
            }
            case "ELBOW": {
                connectionType = Path.Layout.ConnectionType.ELBOW;
                break;
            }
            case "SLANTED": {
                connectionType = Path.Layout.ConnectionType.SLANTED;
                break;
            }
            case "POLYPATH": {
                connectionType = Path.Layout.ConnectionType.POLYPATH;
                break;
            }
            case "BEZIER": {
                connectionType = Path.Layout.ConnectionType.BEZIER;
                break;
            }
            case "BEZIER_3": {
                connectionType = Path.Layout.ConnectionType.BEZIER_3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled connection type: " + connectionTypeString);
            }
        }
        List controlPoints = oldPath.getLayout().getControlPoints();
        String controlPointsString = properties.get("CONTROL_POINTS");
        if (controlPointsString != null) {
            controlPoints = Arrays.asList(controlPointsString.split(";")).stream().map(controlPointString -> {
                String[] coordinateStrings = controlPointString.split(",");
                return new Couple(Long.parseLong(coordinateStrings[0]), Long.parseLong(coordinateStrings[1]));
            }).collect(Collectors.toList());
        }
        Path newPath = oldPath.withLayout(new Path.Layout(connectionType, controlPoints, oldPath.getLayout().getLayerId()));
        this.getObjectRepo().replaceObject((TCSObject<?>)newPath);
        this.emitObjectEvent((TCSObject<?>)newPath, (TCSObject<?>)oldPath, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    private void overrideLocationLayoutData(Location oldLocation, Map<String, String> properties) throws NumberFormatException {
        long positionX = properties.get("POSITION_X") != null ? (long)Integer.parseInt(properties.get("POSITION_X")) : oldLocation.getLayout().getPosition().getX();
        long positionY = properties.get("POSITION_Y") != null ? (long)Integer.parseInt(properties.get("POSITION_Y")) : oldLocation.getLayout().getPosition().getY();
        long labelOffsetX = properties.get("LABEL_OFFSET_X") != null ? (long)Integer.parseInt(properties.get("LABEL_OFFSET_X")) : oldLocation.getLayout().getLabelOffset().getX();
        long labelOffsetY = properties.get("LABEL_OFFSET_Y") != null ? (long)Integer.parseInt(properties.get("LABEL_OFFSET_Y")) : oldLocation.getLayout().getLabelOffset().getY();
        Location newLocation = oldLocation.withLayout(new Location.Layout(new Couple(positionX, positionY), new Couple(labelOffsetX, labelOffsetY), oldLocation.getLayout().getLocationRepresentation(), oldLocation.getLayout().getLayerId()));
        this.getObjectRepo().replaceObject((TCSObject<?>)newLocation);
        this.emitObjectEvent((TCSObject<?>)newLocation, (TCSObject<?>)oldLocation, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    private void overrideBlockLayoutData(Block oldBlock, Map<String, String> properties) throws NumberFormatException {
        Color color = properties.get("COLOR") != null ? Colors.decodeFromHexRGB((String)properties.get("COLOR")) : oldBlock.getLayout().getColor();
        Block newBlock = oldBlock.withLayout(new Block.Layout(color));
        this.getObjectRepo().replaceObject((TCSObject<?>)newBlock);
        this.emitObjectEvent((TCSObject<?>)newBlock, (TCSObject<?>)oldBlock, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    private void overrideVehicleLayoutData(TCSObject<?> object, Map<String, String> properties) throws NumberFormatException {
        Vehicle oldVehicle = (Vehicle)object;
        Color routeColor = properties.get("ROUTE_COLOR") != null ? Colors.decodeFromHexRGB((String)properties.get("ROUTE_COLOR")) : oldVehicle.getLayout().getRouteColor();
        Vehicle newVehicle = oldVehicle.withLayout(new Vehicle.Layout(routeColor));
        this.getObjectRepo().replaceObject((TCSObject<?>)newVehicle);
        this.emitObjectEvent((TCSObject<?>)newVehicle, (TCSObject<?>)oldVehicle, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    private Point addPointIncomingPath(TCSObjectReference<Point> pointRef, TCSObjectReference<Path> pathRef) throws ObjectUnknownException {
        Point point = this.getObjectRepo().getObject(Point.class, pointRef);
        Path path = this.getObjectRepo().getObject(Path.class, pathRef);
        if (!path.getDestinationPoint().equals((Object)point.getReference())) {
            throw new IllegalArgumentException("Point is not the path's destination.");
        }
        Path previousState = path;
        HashSet<TCSResourceReference> incomingPaths = new HashSet<TCSResourceReference>(point.getIncomingPaths());
        incomingPaths.add(path.getReference());
        point = point.withIncomingPaths(incomingPaths);
        this.getObjectRepo().replaceObject((TCSObject<?>)point);
        this.emitObjectEvent((TCSObject<?>)point, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return point;
    }

    private Point addPointOutgoingPath(TCSObjectReference<Point> pointRef, TCSObjectReference<Path> pathRef) throws ObjectUnknownException {
        Point point = this.getObjectRepo().getObject(Point.class, pointRef);
        Path path = this.getObjectRepo().getObject(Path.class, pathRef);
        if (!path.getSourcePoint().equals((Object)point.getReference())) {
            throw new IllegalArgumentException("Point is not the path's source.");
        }
        Path previousState = path;
        HashSet<TCSResourceReference> outgoingPaths = new HashSet<TCSResourceReference>(point.getOutgoingPaths());
        outgoingPaths.add(path.getReference());
        point = point.withOutgoingPaths(outgoingPaths);
        this.getObjectRepo().replaceObject((TCSObject<?>)point);
        this.emitObjectEvent((TCSObject<?>)point, (TCSObject<?>)previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
        return point;
    }

    private static List<Set<TCSResourceReference<?>>> unmodifiableCopy(List<Set<TCSResourceReference<?>>> resources) {
        ArrayList result = new ArrayList();
        for (Set<TCSResourceReference<?>> resSet : resources) {
            result.add(Set.copyOf(resSet));
        }
        return Collections.unmodifiableList(result);
    }
}

