/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernel.workingset;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.ObjectUnknownException;
import org.opentcs.data.TCSObject;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.kernel.workingset.TCSObjectRepository;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCSObjectManager {
    private static final Logger LOG = LoggerFactory.getLogger(TCSObjectManager.class);
    private final TCSObjectRepository objectRepo;
    private final EventHandler eventHandler;

    @Inject
    public TCSObjectManager(@Nonnull TCSObjectRepository objectRepo, @Nonnull @ApplicationEventBus EventHandler eventHandler) {
        this.objectRepo = Objects.requireNonNull(objectRepo, "objectRepo");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
    }

    @Nonnull
    public TCSObjectRepository getObjectRepo() {
        return this.objectRepo;
    }

    public void setObjectProperty(@Nonnull TCSObjectReference<?> ref, @Nonnull String key, @Nullable String value) throws ObjectUnknownException {
        TCSObject object;
        Objects.requireNonNull(ref, "ref");
        Objects.requireNonNull(key, "key");
        TCSObject previousState = object = this.objectRepo.getObject(ref);
        LOG.debug("Setting property on object named '{}': key='{}', value='{}'", new Object[]{ref.getName(), key, value});
        object = object.withProperty(key, value);
        this.objectRepo.replaceObject(object);
        this.emitObjectEvent(object, previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    public void appendObjectHistoryEntry(@Nonnull TCSObjectReference<?> ref, @Nonnull ObjectHistory.Entry entry) throws ObjectUnknownException {
        TCSObject object;
        Objects.requireNonNull(ref, "ref");
        Objects.requireNonNull(entry, "entry");
        TCSObject previousState = object = this.objectRepo.getObject(ref);
        LOG.debug("Appending history entry to object named '{}': {}", (Object)ref.getName(), (Object)entry);
        object = object.withHistoryEntry(entry);
        this.objectRepo.replaceObject(object);
        this.emitObjectEvent(object, previousState, TCSObjectEvent.Type.OBJECT_MODIFIED);
    }

    public void emitObjectEvent(TCSObject<?> currentObjectState, TCSObject<?> previousObjectState, TCSObjectEvent.Type evtType) {
        this.eventHandler.onEvent((Object)new TCSObjectEvent(currentObjectState, previousObjectState, evtType));
    }
}

