/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter;

import com.google.inject.assistedinject.Assisted;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import org.opentcs.access.NotificationPublicationEvent;
import org.opentcs.common.ClientConnectionMode;
import org.opentcs.common.PortalManager;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.kernelcontrolcenter.util.KernelControlCenterConfiguration;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterInfoHandler
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ControlCenterInfoHandler.class);
    private final KernelControlCenterConfiguration configuration;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    private final JTextArea textArea;
    private boolean autoScroll;

    @Inject
    public ControlCenterInfoHandler(@Assisted JTextArea textArea, KernelControlCenterConfiguration configuration) {
        this.textArea = Objects.requireNonNull(textArea, "textArea");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.autoScroll = true;
    }

    public void onEvent(Object event) {
        if (event instanceof PortalManager.ConnectionState) {
            PortalManager.ConnectionState connectionState = (PortalManager.ConnectionState)event;
            SwingUtilities.invokeLater(() -> this.publish(new UserNotification("Kernel connection state: " + connectionState.name(), UserNotification.Level.INFORMATIONAL)));
        } else if (event instanceof ClientConnectionMode) {
            ClientConnectionMode applicationState = (ClientConnectionMode)event;
            SwingUtilities.invokeLater(() -> this.publish(new UserNotification("Application state: " + applicationState.name(), UserNotification.Level.INFORMATIONAL)));
        } else if (event instanceof NotificationPublicationEvent) {
            SwingUtilities.invokeLater(() -> this.publish(((NotificationPublicationEvent)event).getNotification()));
        }
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    private void publish(UserNotification notification) {
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        if (this.autoScroll) {
            caret.setUpdatePolicy(2);
            this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        } else {
            caret.setUpdatePolicy(1);
        }
        this.textArea.append(this.format(notification));
        this.textArea.append("\n");
        this.checkLength();
    }

    private String format(UserNotification notification) {
        return DATE_FORMAT.format(notification.getTimestamp()) + " " + notification.getLevel() + ": [" + notification.getSource() + "] " + notification.getText();
    }

    private synchronized void checkLength() {
        SwingUtilities.invokeLater(() -> {
            int docLength = this.textArea.getDocument().getLength();
            if (docLength > this.configuration.loggingAreaCapacity()) {
                try {
                    this.textArea.getDocument().remove(0, docLength - this.configuration.loggingAreaCapacity());
                }
                catch (BadLocationException e) {
                    LOG.warn("Caught exception", (Throwable)e);
                }
            }
        });
    }
}

