/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter;

import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import javax.inject.Singleton;
import org.opentcs.customizations.controlcenter.ControlCenterInjectionModule;
import org.opentcs.kernelcontrolcenter.ControlCenterInfoHandlerFactory;
import org.opentcs.kernelcontrolcenter.KernelControlCenter;
import org.opentcs.kernelcontrolcenter.peripherals.PeripheralsPanel;
import org.opentcs.kernelcontrolcenter.util.KernelControlCenterConfiguration;
import org.opentcs.kernelcontrolcenter.vehicles.DriverGUI;

public class DefaultKernelControlCenterExtensionsModule
extends ControlCenterInjectionModule {
    protected void configure() {
        this.configureControlCenterDependencies();
    }

    private void configureControlCenterDependencies() {
        KernelControlCenterConfiguration configuration = (KernelControlCenterConfiguration)this.getConfigBindingProvider().get("kernelcontrolcenter", KernelControlCenterConfiguration.class);
        this.bind(KernelControlCenterConfiguration.class).toInstance((Object)configuration);
        this.commAdapterPanelFactoryBinder();
        this.peripheralCommAdapterPanelFactoryBinder();
        Multibinder modellingBinder = this.controlCenterPanelBinderModelling();
        Multibinder operatingBinder = this.controlCenterPanelBinderOperating();
        operatingBinder.addBinding().to(DriverGUI.class);
        if (configuration.enablePeripheralsPanel()) {
            operatingBinder.addBinding().to(PeripheralsPanel.class);
        }
        this.install(new FactoryModuleBuilder().build(ControlCenterInfoHandlerFactory.class));
        this.bind(KernelControlCenter.class).in(Singleton.class);
    }
}

