/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.KernelStateTransitionEvent;
import org.opentcs.access.ModelTransitionEvent;
import org.opentcs.common.ClientConnectionMode;
import org.opentcs.common.KernelClientApplication;
import org.opentcs.common.PortalManager;
import org.opentcs.components.Lifecycle;
import org.opentcs.components.kernelcontrolcenter.ControlCenterPanel;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.customizations.controlcenter.ActiveInModellingMode;
import org.opentcs.customizations.controlcenter.ActiveInOperatingMode;
import org.opentcs.kernelcontrolcenter.AboutDialog;
import org.opentcs.kernelcontrolcenter.ControlCenterInfoHandler;
import org.opentcs.kernelcontrolcenter.ControlCenterInfoHandlerFactory;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.opentcs.util.gui.Icons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelControlCenter
extends JFrame
implements Lifecycle,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KernelControlCenter.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
    private final ControlCenterInfoHandlerFactory controlCenterInfoHandlerFactoy;
    private final Collection<Provider<ControlCenterPanel>> panelProvidersModelling;
    private final Collection<Provider<ControlCenterPanel>> panelProvidersOperating;
    private final AboutDialog aboutDialog;
    private final Set<ControlCenterPanel> activePanels = Collections.synchronizedSet(new HashSet());
    private final KernelClientApplication application;
    private final EventSource eventSource;
    private final KernelServicePortal servicePortal;
    private final PortalManager portalManager;
    private final CallWrapper callWrapper;
    private boolean initialized;
    private ControlCenterInfoHandler infoHandler;
    private String currentModel = "";
    private JCheckBox autoScrollCheckBox;
    private JPopupMenu.Separator jSeparator1;
    private JPanel loggingPanel;
    private JPanel loggingPropertyPanel;
    private JScrollPane loggingScrollPane;
    private JTextArea loggingTextArea;
    private JMenuItem menuAbout;
    private JMenuBar menuBarMain;
    private JMenuItem menuButtonConnect;
    private JMenuItem menuButtonDisconnect;
    private JMenuItem menuButtonExit;
    private JMenu menuHelp;
    private JMenu menuKernel;
    private JTabbedPane tabbedPaneMain;

    @Inject
    public KernelControlCenter(@Nonnull KernelClientApplication application, @Nonnull KernelServicePortal servicePortal, @Nonnull @ServiceCallWrapper CallWrapper callWrapper, @Nonnull PortalManager portalManager, @ApplicationEventBus EventSource eventSource, @Nonnull ControlCenterInfoHandlerFactory controlCenterInfoHandlerFactory, @Nonnull @ActiveInModellingMode Collection<Provider<ControlCenterPanel>> panelProvidersModelling, @Nonnull @ActiveInOperatingMode Collection<Provider<ControlCenterPanel>> panelProvidersOperating) {
        this.application = Objects.requireNonNull(application, "application");
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.portalManager = Objects.requireNonNull(portalManager, "portalManager");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
        this.controlCenterInfoHandlerFactoy = Objects.requireNonNull(controlCenterInfoHandlerFactory, "controlCenterInfoHandlerFactory");
        this.panelProvidersModelling = Objects.requireNonNull(panelProvidersModelling, "panelProvidersModelling");
        this.panelProvidersOperating = Objects.requireNonNull(panelProvidersOperating, "panelProvidersOperating");
        this.initComponents();
        this.setIconImages(Icons.getOpenTCSIcons());
        this.aboutDialog = new AboutDialog((Frame)this, false);
        this.aboutDialog.setAlwaysOnTop(true);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.initialized) {
            LOG.debug("Already initialized.");
            return;
        }
        this.registerControlCenterInfoHandler();
        this.eventSource.subscribe((EventHandler)this);
        this.enteringKernelState(Kernel.State.MODELLING);
        try {
            EventQueue.invokeAndWait(() -> this.setVisible(true));
        }
        catch (InterruptedException | InvocationTargetException exc) {
            throw new IllegalStateException("Unexpected exception initializing", exc);
        }
        this.initialized = true;
    }

    public void terminate() {
        if (!this.initialized) {
            LOG.debug("Not initialized");
            return;
        }
        this.removePanels(this.activePanels);
        this.eventSource.unsubscribe((EventHandler)this);
        this.eventSource.unsubscribe((EventHandler)this.infoHandler);
        this.setVisible(false);
        this.dispose();
        this.initialized = false;
    }

    private void onKernelConnect() {
        try {
            Kernel.State kernelState = (Kernel.State)this.callWrapper.call(() -> this.servicePortal.getState());
            this.enteringKernelState(kernelState);
        }
        catch (Exception ex) {
            LOG.warn("Error getting the kernel state", (Throwable)ex);
        }
    }

    private void onKernelDisconnect() {
        this.leavingKernelState(Kernel.State.OPERATING);
        this.enteringKernelState(Kernel.State.MODELLING);
    }

    public void onEvent(Object event) {
        if (event instanceof ClientConnectionMode) {
            ClientConnectionMode applicationState = (ClientConnectionMode)event;
            switch (applicationState) {
                case ONLINE: {
                    this.onKernelConnect();
                    break;
                }
                case OFFLINE: {
                    this.onKernelDisconnect();
                    break;
                }
                default: {
                    LOG.debug("Unhandled connection state: {}", (Object)applicationState.name());
                    break;
                }
            }
        } else if (event instanceof PortalManager.ConnectionState) {
            PortalManager.ConnectionState connectionState = (PortalManager.ConnectionState)event;
            switch (connectionState) {
                case CONNECTED: {
                    this.updateWindowTitle();
                    break;
                }
                case DISCONNECTED: {
                    this.updateWindowTitle();
                    break;
                }
            }
            this.menuButtonConnect.setEnabled(!this.portalManager.isConnected());
            this.menuButtonDisconnect.setEnabled(this.portalManager.isConnected());
        } else if (event instanceof KernelStateTransitionEvent) {
            KernelStateTransitionEvent stateEvent = (KernelStateTransitionEvent)event;
            if (!stateEvent.isTransitionFinished()) {
                this.leavingKernelState(stateEvent.getLeftState());
            } else {
                this.enteringKernelState(stateEvent.getEnteredState());
            }
        } else if (event instanceof ModelTransitionEvent) {
            ModelTransitionEvent modelEvent = (ModelTransitionEvent)event;
            this.updateModelName(modelEvent.getNewModelName());
        }
    }

    private void leavingKernelState(Kernel.State oldState) {
        Objects.requireNonNull(oldState, "oldState");
        this.removePanels(this.activePanels);
        this.activePanels.clear();
    }

    private void enteringKernelState(Kernel.State newState) {
        Objects.requireNonNull(newState, "newState");
        switch (newState) {
            case OPERATING: {
                this.addPanels(this.panelProvidersOperating);
                break;
            }
            case MODELLING: {
                this.addPanels(this.panelProvidersModelling);
                break;
            }
        }
        this.updateWindowTitle();
    }

    private void addPanels(Collection<Provider<ControlCenterPanel>> providers) {
        for (Provider<ControlCenterPanel> provider : providers) {
            SwingUtilities.invokeLater(() -> this.addPanel((ControlCenterPanel)provider.get()));
        }
    }

    private void addPanel(ControlCenterPanel panel) {
        panel.initialize();
        this.activePanels.add(panel);
        this.tabbedPaneMain.add(panel.getTitle(), (Component)panel);
    }

    private void removePanels(Collection<ControlCenterPanel> panels) {
        ArrayList<ControlCenterPanel> panelsCopy = new ArrayList<ControlCenterPanel>(panels);
        SwingUtilities.invokeLater(() -> {
            for (ControlCenterPanel panel : panelsCopy) {
                this.tabbedPaneMain.remove((Component)panel);
                panel.terminate();
            }
        });
    }

    private void updateModelName(String newModelName) {
        this.currentModel = newModelName;
        this.updateWindowTitle();
    }

    private boolean confirmExit() {
        int n = JOptionPane.showConfirmDialog(this, BUNDLE.getString("kernelControlCenter.optionPane_exitConfirmation.message"), BUNDLE.getString("kernelControlCenter.optionPane_exitConfirmation.title"), 0);
        return n == 0;
    }

    private void registerControlCenterInfoHandler() {
        this.infoHandler = this.controlCenterInfoHandlerFactoy.createHandler(this.loggingTextArea);
        this.eventSource.subscribe((EventHandler)this.infoHandler);
    }

    private void updateWindowTitle() {
        String titleBase = BUNDLE.getString("kernelControlCenter.title");
        String loadedModel = this.currentModel.equals("") ? "" : " - \"" + this.currentModel + "\"";
        String connectedTo = " - " + BUNDLE.getString("kernelControlCenter.title.connectedTo") + this.portalManager.getDescription() + " (" + this.portalManager.getHost() + ":" + this.portalManager.getPort() + ")";
        this.setTitle(titleBase + loadedModel + connectedTo);
    }

    private void exitApplication() {
        if (this.confirmExit()) {
            this.application.terminate();
        }
    }

    private void initComponents() {
        this.tabbedPaneMain = new JTabbedPane();
        this.loggingPanel = new JPanel();
        this.loggingScrollPane = new JScrollPane();
        this.loggingTextArea = new JTextArea();
        this.loggingPropertyPanel = new JPanel();
        this.autoScrollCheckBox = new JCheckBox();
        this.menuBarMain = new JMenuBar();
        this.menuKernel = new JMenu();
        this.menuButtonConnect = new JMenuItem();
        this.menuButtonDisconnect = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.menuButtonExit = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
        this.setTitle(bundle.getString("kernelControlCenter.title"));
        this.setMinimumSize(new Dimension(1200, 750));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                KernelControlCenter.this.formWindowClosing(evt);
            }
        });
        this.loggingPanel.setLayout(new BorderLayout());
        this.loggingTextArea.setEditable(false);
        this.loggingScrollPane.setViewportView(this.loggingTextArea);
        this.loggingPanel.add((Component)this.loggingScrollPane, "Center");
        this.loggingPropertyPanel.setLayout(new GridBagLayout());
        this.autoScrollCheckBox.setSelected(true);
        this.autoScrollCheckBox.setText(bundle.getString("kernelControlCenter.checkBox_autoScroll.text"));
        this.autoScrollCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KernelControlCenter.this.autoScrollCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.loggingPropertyPanel.add((Component)this.autoScrollCheckBox, gridBagConstraints);
        this.loggingPanel.add((Component)this.loggingPropertyPanel, "First");
        this.tabbedPaneMain.addTab(bundle.getString("kernelControlCenter.tab_logging.title"), this.loggingPanel);
        this.getContentPane().add((Component)this.tabbedPaneMain, "Center");
        this.menuKernel.setText("KernelControlCenter");
        this.menuButtonConnect.setText(bundle.getString("kernelControlCenter.menu_kernel.menuItem_connect.text"));
        this.menuButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KernelControlCenter.this.menuButtonConnectActionPerformed(evt);
            }
        });
        this.menuKernel.add(this.menuButtonConnect);
        this.menuButtonDisconnect.setText(bundle.getString("kernelControlCenter.menu_kernel.menuItem_disconnect.text"));
        this.menuButtonDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KernelControlCenter.this.menuButtonDisconnectActionPerformed(evt);
            }
        });
        this.menuKernel.add(this.menuButtonDisconnect);
        this.menuKernel.add(this.jSeparator1);
        this.menuButtonExit.setText(bundle.getString("kernelControlCenter.menu_kernel.menuItem_exit.text"));
        this.menuButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KernelControlCenter.this.menuButtonExitActionPerformed(evt);
            }
        });
        this.menuKernel.add(this.menuButtonExit);
        this.menuBarMain.add(this.menuKernel);
        this.menuHelp.setText(bundle.getString("kernelControlCenter.menu_help.text"));
        this.menuAbout.setText(bundle.getString("kernelControlCenter.menu_about.text"));
        this.menuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KernelControlCenter.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.menuBarMain.add(this.menuHelp);
        this.setJMenuBar(this.menuBarMain);
        this.setSize(new Dimension(1208, 782));
        this.setLocationRelativeTo(null);
    }

    private void menuButtonExitActionPerformed(ActionEvent evt) {
        this.exitApplication();
    }

    private void autoScrollCheckBoxActionPerformed(ActionEvent evt) {
        if (this.autoScrollCheckBox.isSelected()) {
            this.infoHandler.setAutoScroll(true);
        } else {
            this.infoHandler.setAutoScroll(false);
        }
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        this.aboutDialog.setLocationRelativeTo(null);
        this.aboutDialog.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitApplication();
    }

    private void menuButtonConnectActionPerformed(ActionEvent evt) {
        this.application.online(false);
    }

    private void menuButtonDisconnectActionPerformed(ActionEvent evt) {
        this.application.offline();
    }
}

